/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.common.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.colorado.phet.linegraphing.common.LGColors;
import edu.colorado.phet.linegraphing.common.LGResources;
import edu.colorado.phet.linegraphing.common.LGSimSharing;
import edu.colorado.phet.linegraphing.common.model.Graph;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.common.model.PointTool;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointToolNode
extends PhetPNode {
    private static final NumberFormat COORDINATES_FORMAT = new DefaultDecimalFormat("0");
    private final PNode bodyNode = new PImage(LGResources.Images.POINT_TOOL_BODY);
    private final PPath backgroundNode;
    private final PText valueNode;

    public PointToolNode(final PointTool pointTool, final ModelViewTransform modelViewTransform, final Graph graph, Rectangle2D rectangle2D, final Property<Boolean> property) {
        this(pointTool.location.get(), pointTool.orientation, LGColors.POINT_TOOL_BACKGROUND_NORMAL_COLOR);
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                Vector2D vector2D = pointTool.location.get();
                PointToolNode.this.setOffset(modelViewTransform.modelToView(vector2D).toPoint2D());
                if (graph.contains(vector2D)) {
                    PointToolNode.this.setCoordinates(vector2D);
                    if (((Boolean)property.get()).booleanValue()) {
                        Line line = pointTool.onLine.get();
                        PointToolNode.this.setForeground(line == null ? LGColors.POINT_TOOL_FOREGROUND_NORMAL_COLOR : LGColors.POINT_TOOL_FOREGROUND_HIGHLIGHT_COLOR);
                        PointToolNode.this.setBackground(line == null ? LGColors.POINT_TOOL_BACKGROUND_NORMAL_COLOR : line.color);
                    } else {
                        PointToolNode.this.setForeground(LGColors.POINT_TOOL_FOREGROUND_NORMAL_COLOR);
                        PointToolNode.this.setBackground(LGColors.POINT_TOOL_BACKGROUND_NORMAL_COLOR);
                    }
                } else {
                    PointToolNode.this.setCoordinates(LGResources.Strings.POINT_UNKNOWN);
                    PointToolNode.this.setForeground(LGColors.POINT_TOOL_FOREGROUND_NORMAL_COLOR);
                    PointToolNode.this.setBackground(LGColors.POINT_TOOL_BACKGROUND_NORMAL_COLOR);
                }
            }
        };
        richSimpleObserver.observe(pointTool.location, pointTool.onLine, property);
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new PointToolDragHandler(this, pointTool.location, modelViewTransform, graph, rectangle2D));
    }

    public PointToolNode(Vector2D vector2D, PointTool.Orientation orientation, Color color) {
        PImage pImage = new PImage(LGResources.Images.POINT_TOOL_TIP);
        pImage.setPickable(false);
        this.backgroundNode = new PPath(new Rectangle2D.Double(0.0, 0.0, this.bodyNode.getFullBoundsReference().getWidth() - 10.0, this.bodyNode.getFullBoundsReference().getHeight() - 10.0));
        this.backgroundNode.setStroke(null);
        this.backgroundNode.setOffset(this.bodyNode.getOffset());
        this.backgroundNode.setPickable(false);
        this.valueNode = new PText("?");
        this.valueNode.setFont(new PhetFont(1, 15));
        this.valueNode.setPickable(false);
        this.addChild(pImage);
        this.addChild(this.backgroundNode);
        this.addChild(this.bodyNode);
        this.addChild(this.valueNode);
        if (orientation == PointTool.Orientation.DOWN) {
            pImage.setOffset(-pImage.getFullBoundsReference().getWidth() / 2.0, -pImage.getFullBoundsReference().getHeight());
            this.bodyNode.setOffset(-this.bodyNode.getFullBoundsReference().getWidth() / 2.0, pImage.getFullBoundsReference().getMinY() - this.bodyNode.getFullBoundsReference().getHeight());
            this.backgroundNode.setOffset(this.bodyNode.getXOffset() + 5.0, this.bodyNode.getYOffset() + 5.0);
            this.valueNode.setOffset(0.0, this.bodyNode.getFullBoundsReference().getMinY() + 21.0 - this.valueNode.getFullBoundsReference().getHeight() / 2.0);
        } else {
            pImage.rotate(Math.PI);
            pImage.setOffset(pImage.getFullBoundsReference().getWidth() / 2.0, pImage.getFullBoundsReference().getHeight());
            this.bodyNode.setOffset(-this.bodyNode.getFullBoundsReference().getWidth() / 2.0, pImage.getFullBoundsReference().getMaxY());
            this.backgroundNode.setOffset(this.bodyNode.getFullBoundsReference().getMinX() + 5.0, this.bodyNode.getFullBoundsReference().getMinY() + 5.0);
            this.valueNode.setOffset(0.0, this.bodyNode.getFullBoundsReference().getMaxY() - 21.0 - this.valueNode.getFullBoundsReference().getHeight() / 2.0);
        }
        this.setCoordinates(vector2D);
        this.setBackground(color);
    }

    private void setCoordinates(Vector2D vector2D) {
        this.setCoordinates(MessageFormat.format(LGResources.Strings.POINT_XY, COORDINATES_FORMAT.format(vector2D.getX()), COORDINATES_FORMAT.format(vector2D.getY())));
    }

    private void setCoordinates(String string) {
        this.valueNode.setText(string);
        this.valueNode.setOffset(this.bodyNode.getFullBoundsReference().getCenterX() - this.valueNode.getFullBoundsReference().getWidth() / 2.0, this.valueNode.getYOffset());
    }

    private void setForeground(Color color) {
        this.valueNode.setTextPaint(color);
    }

    private void setBackground(Color color) {
        this.backgroundNode.setPaint(color);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PointToolDragHandler
    extends SimSharingDragHandler {
        private final PNode dragNode;
        private final Property<Vector2D> point;
        private final ModelViewTransform mvt;
        private final Graph graph;
        private final Rectangle2D dragBounds;
        private double clickXOffset;
        private double clickYOffset;

        public PointToolDragHandler(PNode pNode, Property<Vector2D> property, ModelViewTransform modelViewTransform, Graph graph, Rectangle2D rectangle2D) {
            super(LGSimSharing.UserComponents.pointTool, UserComponentTypes.sprite, true);
            this.dragNode = pNode;
            this.point = property;
            this.mvt = modelViewTransform;
            this.graph = graph;
            this.dragBounds = rectangle2D;
        }

        @Override
        protected void startDrag(PInputEvent pInputEvent) {
            super.startDrag(pInputEvent);
            Point2D point2D = pInputEvent.getPositionRelativeTo(this.dragNode.getParent());
            this.clickXOffset = point2D.getX() - this.mvt.modelToViewX(this.point.get().getX());
            this.clickYOffset = point2D.getY() - this.mvt.modelToViewY(this.point.get().getY());
            this.dragNode.moveToFront();
        }

        @Override
        protected void drag(PInputEvent pInputEvent) {
            super.drag(pInputEvent);
            Point2D point2D = pInputEvent.getPositionRelativeTo(this.dragNode.getParent());
            double d = point2D.getX() - this.clickXOffset;
            double d2 = point2D.getY() - this.clickYOffset;
            Vector2D vector2D = this.constrainToBounds(d, d2);
            this.point.set(this.mvt.viewToModel(vector2D));
            Vector2D vector2D2 = this.mvt.viewToModel(vector2D);
            if (this.graph.contains(this.point.get())) {
                this.point.set(new Vector2D(MathUtil.roundHalfUp(vector2D2.getX()), MathUtil.roundHalfUp(vector2D2.getY())));
            } else {
                this.point.set(vector2D2);
            }
        }

        @Override
        public ParameterSet getParametersForAllEvents(PInputEvent pInputEvent) {
            return new ParameterSet().with((IParameterKey)LGSimSharing.ParameterKeys.x, COORDINATES_FORMAT.format(this.point.get().getX())).with((IParameterKey)LGSimSharing.ParameterKeys.y, COORDINATES_FORMAT.format(this.point.get().getY())).with(super.getParametersForAllEvents(pInputEvent));
        }

        private Vector2D constrainToBounds(double d, double d2) {
            return new Vector2D(MathUtil.clamp(this.dragBounds.getMinX(), d, this.dragBounds.getMaxX()), MathUtil.clamp(this.dragBounds.getMinY(), d2, this.dragBounds.getMaxY()));
        }
    }
}

