/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.common.view;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.DoubleArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.linegraphing.common.model.Graph;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;

public class LineNode
extends PComposite {
    private static final PDimension ARROW_HEAD_SIZE = new PDimension(10.0, 10.0);
    private static final PhetFont EQUATION_FONT = new PhetFont(1, 18);
    public final Line line;
    private final DoubleArrowNode arrowNode;
    private final PNode equationParentNode;
    private final Vector2D tailLocation;
    private final Vector2D tipLocation;

    public LineNode(Line line, Graph graph, ModelViewTransform modelViewTransform) {
        double d;
        double d2;
        double d3;
        double d4;
        this.line = line;
        double d5 = modelViewTransform.viewToModelDeltaX(25.0);
        double d6 = Math.abs(modelViewTransform.viewToModelDeltaY(25.0));
        if (line.run == 0.0) {
            d4 = line.x1;
            d3 = (double)graph.yRange.getMax() + d6;
            d2 = line.x1;
            d = (double)graph.yRange.getMin() - d6;
        } else if (line.rise == 0.0) {
            d4 = (double)graph.xRange.getMin() - d5;
            d3 = line.y1;
            d2 = (double)graph.xRange.getMax() + d6;
            d = line.y1;
        } else {
            d4 = (double)graph.xRange.getMin() - d5;
            d3 = line.solveY(d4);
            if (d3 < (double)graph.yRange.getMin() - d6) {
                d4 = line.solveX((double)graph.yRange.getMin() - d6);
                d3 = line.solveY(d4);
            } else if (d3 > (double)graph.yRange.getMax() + d6) {
                d4 = line.solveX((double)graph.yRange.getMax() + d6);
                d3 = line.solveY(d4);
            }
            d2 = (double)graph.xRange.getMax() + d5;
            d = line.solveY(d2);
            if (d < (double)graph.yRange.getMin() - d6) {
                d2 = line.solveX((double)graph.yRange.getMin() - d6);
                d = line.solveY(d2);
            } else if (d > (double)graph.yRange.getMax() + d6) {
                d2 = line.solveX((double)graph.yRange.getMax() + d6);
                d = line.solveY(d2);
            }
        }
        this.tailLocation = new Vector2D(modelViewTransform.modelToViewX(d4), modelViewTransform.modelToViewY(d3));
        this.tipLocation = new Vector2D(modelViewTransform.modelToViewX(d2), modelViewTransform.modelToViewY(d));
        this.arrowNode = new DoubleArrowNode(this.tailLocation.toPoint2D(), this.tipLocation.toPoint2D(), ARROW_HEAD_SIZE.getHeight(), ARROW_HEAD_SIZE.getWidth(), 3.0);
        this.arrowNode.setPaint(line.color);
        this.arrowNode.setStroke(null);
        this.addChild(this.arrowNode);
        this.equationParentNode = new PNode();
        this.addChild(this.equationParentNode);
        this.equationParentNode.setOffset(this.tipLocation.toPoint2D());
        this.equationParentNode.setRotation(line.undefinedSlope() ? 1.5707963267948966 : -Math.atan(line.getSlope()));
        this.updateEquation(line, EQUATION_FONT, line.color);
    }

    protected PNode createEquationNode(Line line, PhetFont phetFont, Color color) {
        return new PNode();
    }

    public void setEquationVisible(boolean bl) {
        this.equationParentNode.setVisible(bl);
    }

    protected void updateColor(Color color) {
        this.arrowNode.setPaint(color);
        this.updateEquation(this.line, EQUATION_FONT, color);
    }

    private void updateEquation(Line line, PhetFont phetFont, Color color) {
        this.equationParentNode.removeAllChildren();
        ZeroOffsetNode zeroOffsetNode = new ZeroOffsetNode(this.createEquationNode(line, phetFont, color));
        this.equationParentNode.addChild(new ZeroOffsetNode((PNode)zeroOffsetNode));
        if (line.undefinedSlope()) {
            if (line.rise < 0.0) {
                this.equationParentNode.setOffset(this.tipLocation.toPoint2D());
                zeroOffsetNode.setOffset(-zeroOffsetNode.getFullBoundsReference().getWidth() - 30.0, -zeroOffsetNode.getFullBoundsReference().getHeight() - 12.0);
            } else {
                this.equationParentNode.setOffset(this.tailLocation.toPoint2D());
                zeroOffsetNode.setOffset(30.0, -zeroOffsetNode.getFullBoundsReference().getHeight() - 12.0);
            }
        } else if (line.rise <= 0.0) {
            if (line.run >= 0.0) {
                this.equationParentNode.setOffset(this.tipLocation.toPoint2D());
                zeroOffsetNode.setOffset(-zeroOffsetNode.getFullBoundsReference().getWidth() - 30.0, -zeroOffsetNode.getFullBoundsReference().getHeight() - 12.0);
            } else {
                this.equationParentNode.setOffset(this.tailLocation.toPoint2D());
                zeroOffsetNode.setOffset(30.0, -zeroOffsetNode.getFullBoundsReference().getHeight() - 12.0);
            }
        } else if (line.run > 0.0) {
            this.equationParentNode.setOffset(this.tipLocation.toPoint2D());
            zeroOffsetNode.setOffset(-zeroOffsetNode.getFullBoundsReference().getWidth() - 30.0, 10.0);
        } else {
            this.equationParentNode.setOffset(this.tailLocation.toPoint2D());
            zeroOffsetNode.setOffset(30.0, 10.0);
        }
    }
}

