/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.common.view;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.SettableNot;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.util.ObservableList;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyCheckBox;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyCheckBoxWithIcon;
import edu.colorado.phet.common.phetcommon.view.util.GridPanel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.linegraphing.common.LGColors;
import edu.colorado.phet.linegraphing.common.LGResources;
import edu.colorado.phet.linegraphing.common.LGSimSharing;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.common.view.GraphNode;
import edu.colorado.phet.linegraphing.common.view.SlopeToolNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphControls
extends PNode {
    private static final PhetFont CONTROL_FONT = new PhetFont(0, 14);
    private static final String Y_EQUALS_X = MessageFormat.format("{0} = {1}", LGResources.Strings.SYMBOL_Y, LGResources.Strings.SYMBOL_X);
    private static final String Y_EQUALS_NEGATIVE_X = MessageFormat.format("{0} = -{1}", LGResources.Strings.SYMBOL_Y, LGResources.Strings.SYMBOL_X);

    public GraphControls(Property<Boolean> property, Property<Boolean> property2, ObservableList<Line> observableList) {
        this(property, property2, observableList, true);
    }

    public GraphControls(Property<Boolean> property, Property<Boolean> property2) {
        this(property, property2, new ObservableList<Line>(), false);
    }

    private GraphControls(Property<Boolean> property, Property<Boolean> property2, final ObservableList<Line> observableList, boolean bl) {
        final Property<Boolean> property3 = new Property<Boolean>(observableList.contains(Line.Y_EQUALS_X_LINE));
        final Property<Boolean> property4 = new Property<Boolean>(observableList.contains(Line.Y_EQUALS_NEGATIVE_X_LINE));
        final PropertyCheckBox propertyCheckBox = new PropertyCheckBox(LGSimSharing.UserComponents.linesCheckBox, LGResources.Strings.HIDE_LINES, new SettableNot((SettableProperty<Boolean>)property));
        propertyCheckBox.setFont(CONTROL_FONT);
        final PropertyCheckBoxWithIcon propertyCheckBoxWithIcon = new PropertyCheckBoxWithIcon(LGSimSharing.UserComponents.yEqualsXCheckBox, Y_EQUALS_X, CONTROL_FONT, GraphNode.createYEqualsXIcon(60.0, LGColors.Y_EQUALS_X), property3);
        final PropertyCheckBoxWithIcon propertyCheckBoxWithIcon2 = new PropertyCheckBoxWithIcon(LGSimSharing.UserComponents.yEqualsNegativeXCheckBox, Y_EQUALS_NEGATIVE_X, CONTROL_FONT, GraphNode.createYEqualsNegativeXIcon(60.0, LGColors.Y_EQUALS_NEGATIVE_X), property4);
        final PropertyCheckBoxWithIcon propertyCheckBoxWithIcon3 = new PropertyCheckBoxWithIcon(LGSimSharing.UserComponents.riseOverRunCheckBox, LGResources.Strings.SLOPE, CONTROL_FONT, SlopeToolNode.createIcon(60.0), property2);
        GridPanel gridPanel = new GridPanel();
        gridPanel.setGridX(0);
        gridPanel.setInsets(new Insets(2, 2, 2, 2));
        gridPanel.setAnchor(GridPanel.Anchor.CENTER);
        gridPanel.setFill(GridPanel.Fill.NONE);
        gridPanel.setAnchor(GridPanel.Anchor.WEST);
        gridPanel.add(propertyCheckBoxWithIcon3);
        if (bl) {
            gridPanel.add(propertyCheckBoxWithIcon);
            gridPanel.add(propertyCheckBoxWithIcon2);
        }
        gridPanel.add(new JPanel(){
            {
                this.add(propertyCheckBox);
            }
        });
        this.addChild(new ControlPanelNode(gridPanel, LGColors.GRAPH_CONTROL_PANEL));
        property.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                propertyCheckBoxWithIcon3.setEnabled(bl);
                propertyCheckBoxWithIcon.setEnabled(bl);
                propertyCheckBoxWithIcon2.setEnabled(bl);
            }
        });
        property3.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                if (bl.booleanValue()) {
                    observableList.add(Line.Y_EQUALS_X_LINE);
                } else {
                    observableList.remove(Line.Y_EQUALS_X_LINE);
                }
            }
        });
        property4.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                if (bl.booleanValue()) {
                    observableList.add(Line.Y_EQUALS_NEGATIVE_X_LINE);
                } else {
                    observableList.remove(Line.Y_EQUALS_NEGATIVE_X_LINE);
                }
            }
        });
        observableList.addElementAddedObserver(new VoidFunction1<Line>(){

            @Override
            public void apply(Line line) {
                if (line == Line.Y_EQUALS_X_LINE) {
                    property3.set(true);
                } else if (line == Line.Y_EQUALS_NEGATIVE_X_LINE) {
                    property4.set(true);
                }
            }
        });
        observableList.addElementRemovedObserver(new VoidFunction1<Line>(){

            @Override
            public void apply(Line line) {
                if (line == Line.Y_EQUALS_X_LINE) {
                    property3.set(false);
                } else if (line == Line.Y_EQUALS_NEGATIVE_X_LINE) {
                    property4.set(false);
                }
            }
        });
    }
}

