/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.common.view;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.linegraphing.common.LGSimSharing;
import edu.colorado.phet.linegraphing.common.view.spinner.SlopeSpinnerNode;
import edu.colorado.phet.linegraphing.common.view.spinner.SpinnerStateIndicator;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EquationNode
extends PhetPNode {
    protected static final NumberFormat FORMAT = new DefaultDecimalFormat("0");
    protected final double slopeSignYOffset;
    protected final double slopeSignYFudgeFactor;
    protected final double operatorYFudgeFactor;
    protected final double fractionLineYFudgeFactor;
    protected final double undefinedSlopeYFudgeFactor;
    private final float fractionLineThickness;
    protected final PDimension operatorLineSize;
    protected final PDimension signLineSize;
    protected final double integerSignXSpacing;
    protected final double fractionSignXSpacing;
    protected final double integerSlopeXSpacing;
    protected final double fractionalSlopeXSpacing;
    protected final double operatorXSpacing;
    protected final double relationalOperatorXSpacing;
    protected final double parenXSpacing;
    protected final double spinnersYSpacing;
    protected final double slopeYSpacing;
    protected final double ySpacing;

    protected EquationNode(int n) {
        this.slopeSignYOffset = 0.0;
        this.slopeSignYFudgeFactor = 0.07 * (double)n;
        this.operatorYFudgeFactor = 0.07 * (double)n;
        this.fractionLineYFudgeFactor = 0.07 * (double)n;
        this.undefinedSlopeYFudgeFactor = 0.07 * (double)n;
        this.fractionLineThickness = 0.06f * (float)n;
        this.operatorLineSize = new PDimension(0.54 * (double)n, 0.07 * (double)n);
        this.signLineSize = new PDimension(0.54 * (double)n, 0.11 * (double)n);
        this.integerSignXSpacing = 0.18 * (double)n;
        this.fractionSignXSpacing = 0.36 * (double)n;
        this.integerSlopeXSpacing = 0.04 * (double)n;
        this.fractionalSlopeXSpacing = 0.15 * (double)n;
        this.operatorXSpacing = 0.25 * (double)n;
        this.relationalOperatorXSpacing = 0.35 * (double)n;
        this.parenXSpacing = 0.07 * (double)n;
        this.ySpacing = 0.1 * (double)n;
        this.spinnersYSpacing = 0.2 * (double)n;
        this.slopeYSpacing = 0.4 * (double)n;
    }

    protected Shape createFractionLineShape(double d) {
        return new Rectangle2D.Double(0.0, 0.0, d, this.fractionLineThickness);
    }

    protected static double computeMaxSlopeSpinnerWidth(Property<DoubleRange> property, Property<DoubleRange> property2, PhetFont phetFont, NumberFormat numberFormat) {
        SlopeSpinnerNode.RiseSpinnerNode riseSpinnerNode = new SlopeSpinnerNode.RiseSpinnerNode(LGSimSharing.UserComponents.riseSpinner, new Property<Double>(property.get().getMax()), new Property<Double>(property2.get().getMax()), property, new SpinnerStateIndicator.SlopeColors(), phetFont, numberFormat);
        SlopeSpinnerNode.RiseSpinnerNode riseSpinnerNode2 = new SlopeSpinnerNode.RiseSpinnerNode(LGSimSharing.UserComponents.riseSpinner, new Property<Double>(property.get().getMin()), new Property<Double>(property2.get().getMax()), property, new SpinnerStateIndicator.SlopeColors(), phetFont, numberFormat);
        SlopeSpinnerNode.RunSpinnerNode runSpinnerNode = new SlopeSpinnerNode.RunSpinnerNode(LGSimSharing.UserComponents.riseSpinner, new Property<Double>(property.get().getMin()), new Property<Double>(property2.get().getMax()), property2, new SpinnerStateIndicator.SlopeColors(), phetFont, numberFormat);
        SlopeSpinnerNode.RunSpinnerNode runSpinnerNode2 = new SlopeSpinnerNode.RunSpinnerNode(LGSimSharing.UserComponents.riseSpinner, new Property<Double>(property.get().getMin()), new Property<Double>(property2.get().getMin()), property2, new SpinnerStateIndicator.SlopeColors(), phetFont, numberFormat);
        double d = Math.max(riseSpinnerNode.getFullBoundsReference().getWidth(), riseSpinnerNode2.getFullBoundsReference().getWidth());
        double d2 = Math.max(runSpinnerNode.getFullBoundsReference().getWidth(), runSpinnerNode2.getFullBoundsReference().getWidth());
        return Math.max(d, d2);
    }
}

