/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.common.model;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.linegraphing.common.LGColors;
import edu.colorado.phet.linegraphing.common.model.Fraction;
import java.awt.Color;

public class Line {
    private static final Color DEFAULT_COLOR = Color.BLACK;
    public static final Line Y_EQUALS_X_LINE = new Line(0.0, 0.0, 1.0, 1.0, LGColors.Y_EQUALS_X);
    public static final Line Y_EQUALS_NEGATIVE_X_LINE = new Line(0.0, 0.0, 1.0, -1.0, LGColors.Y_EQUALS_NEGATIVE_X);
    public final double x1;
    public final double y1;
    public final double x2;
    public final double y2;
    public final double rise;
    public final double run;
    public final Color color;

    public Line(double d, double d2, double d3, double d4, Color color) {
        assert (d != d3 || d2 != d4);
        this.x1 = d;
        this.y1 = d2;
        this.x2 = d3;
        this.y2 = d4;
        this.rise = d4 - d2;
        this.run = d3 - d;
        this.color = color;
    }

    public static Line createPointSlope(double d, double d2, double d3, double d4, Color color) {
        return new Line(d, d2, d + d4, d2 + d3, color);
    }

    public static Line createPointSlope(double d, double d2, double d3, double d4) {
        return Line.createPointSlope(d, d2, d3, d4, DEFAULT_COLOR);
    }

    public static Line createSlopeIntercept(double d, double d2, double d3, Color color) {
        return Line.createPointSlope(0.0, d3, d, d2, color);
    }

    public static Line createSlopeIntercept(double d, double d2, double d3) {
        return Line.createSlopeIntercept(d, d2, d3, DEFAULT_COLOR);
    }

    public Line withColor(Color color) {
        return new Line(this.x1, this.y1, this.x2, this.y2, color);
    }

    public double getSlope() {
        if (this.undefinedSlope()) {
            return Double.NaN;
        }
        return this.rise / this.run;
    }

    public boolean undefinedSlope() {
        return this.run == 0.0;
    }

    public double solveY(double d) {
        if (this.undefinedSlope()) {
            return Double.NaN;
        }
        return this.getSlope() * (d - this.x1) + this.y1;
    }

    public double solveX(double d) {
        if (this.rise == 0.0 || this.run == 0.0) {
            return Double.NaN;
        }
        return (d - this.y1) / (this.rise / this.run) + this.x1;
    }

    public boolean same(Line line) {
        return line != null && this.onLine(line.x1, line.y1) && this.onLine(line.x2, line.y2);
    }

    public double getSimplifiedRise() {
        if (this.slopeIsSimplifiable()) {
            return this.rise / (double)MathUtil.getGreatestCommonDivisor((int)this.rise, (int)this.run);
        }
        return this.rise;
    }

    public double getSimplifiedRun() {
        if (this.slopeIsSimplifiable()) {
            return this.run / (double)MathUtil.getGreatestCommonDivisor((int)this.rise, (int)this.run);
        }
        return this.run;
    }

    private boolean slopeIsSimplifiable() {
        return this.rise != 0.0 && this.run != 0.0 && MathUtil.isInteger(this.rise) && MathUtil.isInteger(this.run);
    }

    public boolean onLine(Vector2D vector2D) {
        return this.onLine(vector2D.getX(), vector2D.getY());
    }

    public boolean onLine(double d, double d2) {
        if (this.rise == 0.0) {
            return d2 == this.y1;
        }
        if (this.run == 0.0) {
            return d == this.x1;
        }
        return d == this.solveX(d2);
    }

    public Fraction getYIntercept() {
        assert (MathUtil.isInteger(this.x1) && MathUtil.isInteger(this.y1) && MathUtil.isInteger(this.rise) && MathUtil.isInteger(this.run));
        if (this.rise == 0.0 || this.run == 0.0) {
            return new Fraction((int)this.y1, 1);
        }
        int n = (int)(this.y1 * this.run - this.x1 * this.rise);
        int n2 = (int)this.run;
        int n3 = MathUtil.getGreatestCommonDivisor(n, n2);
        return new Fraction(n / n3, n2 / n3);
    }

    public String toString() {
        return "x1=" + this.x1 + ", y1=" + this.y1 + ", x2=" + this.x2 + ", y2=" + this.y2 + ", rise=" + this.rise + ", run=" + this.run + ", color=" + this.color;
    }
}

