/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.util.logging.LoggingUtils;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;

public class CenteredStageCanvas
extends PhetPCanvas
implements Resettable {
    private static final Logger LOGGER = LoggingUtils.getLogger(CenteredStageCanvas.class.getCanonicalName());
    private final PNode rootNode;
    private final Dimension2D stageSize;

    public CenteredStageCanvas() {
        this(PhetPCanvas.CenteredStage.DEFAULT_STAGE_SIZE);
    }

    public CenteredStageCanvas(Dimension2D dimension2D) {
        this.stageSize = dimension2D;
        this.setWorldTransformStrategy(new PhetPCanvas.CenteredStage(this, dimension2D));
        if (PhetApplication.getInstance().getSimInfo().hasCommandLineArg("-showStageBounds")) {
            this.addBoundsNode(dimension2D);
        }
        this.rootNode = new PNode();
        this.addWorldChild(this.rootNode);
    }

    public void addChild(PNode pNode) {
        this.rootNode.addChild(pNode);
    }

    public Dimension2D getStageSize() {
        return new PDimension(this.stageSize);
    }

    public double getStageWidth() {
        return this.stageSize.getWidth();
    }

    public double getStageHeight() {
        return this.stageSize.getHeight();
    }

    public Rectangle2D getStageBounds() {
        return new Rectangle2D.Double(-this.rootNode.getXOffset(), -this.rootNode.getYOffset(), this.getStageWidth(), this.getStageHeight());
    }

    public void reset() {
    }
}

