/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import javax.swing.JPanel;

public class GridPanel
extends JPanel {
    private static final TwoWayMap<Anchor, Integer> ANCHOR_MAP = new TwoWayMap<Anchor, Integer>(){
        {
            this.put(Anchor.CENTER, new Integer(10));
            this.put(Anchor.NORTH, new Integer(11));
            this.put(Anchor.NORTHEAST, new Integer(12));
            this.put(Anchor.EAST, new Integer(13));
            this.put(Anchor.SOUTHEAST, new Integer(14));
            this.put(Anchor.SOUTH, new Integer(15));
            this.put(Anchor.SOUTHWEST, new Integer(16));
            this.put(Anchor.WEST, new Integer(17));
            this.put(Anchor.NORTHWEST, new Integer(18));
            this.put(Anchor.PAGE_START, new Integer(19));
            this.put(Anchor.PAGE_END, new Integer(20));
            this.put(Anchor.LINE_START, new Integer(21));
            this.put(Anchor.LINE_END, new Integer(22));
            this.put(Anchor.FIRST_LINE_START, new Integer(23));
            this.put(Anchor.FIRST_LINE_END, new Integer(24));
            this.put(Anchor.LAST_LINE_START, new Integer(25));
            this.put(Anchor.LAST_LINE_END, new Integer(26));
            assert (this.size() == Anchor.values().length);
        }
    };
    private static final TwoWayMap<Fill, Integer> FILL_MAP = new TwoWayMap<Fill, Integer>(){
        {
            this.put(Fill.HORIZONTAL, new Integer(2));
            this.put(Fill.VERTICAL, new Integer(3));
            this.put(Fill.BOTH, new Integer(1));
            this.put(Fill.NONE, new Integer(0));
            assert (this.size() == Fill.values().length);
        }
    };
    private final GridBagConstraints constraints;

    public GridPanel() {
        this(new GridBagConstraints());
    }

    private GridPanel(GridBagConstraints gridBagConstraints) {
        super(new GridBagLayout());
        this.constraints = gridBagConstraints;
    }

    public void setLayout(LayoutManager layoutManager) {
        if (!(layoutManager instanceof GridBagLayout)) {
            throw new UnsupportedOperationException("layout manager must be a GridBagLayout");
        }
        super.setLayout(layoutManager);
    }

    public Component add(Component component) {
        super.add(component, this.constraints);
        return component;
    }

    public void add(Component component, int n, int n2, int n3, int n4, double d, double d2, Anchor anchor, Fill fill, Insets insets, int n5, int n6) {
        GridBagConstraints gridBagConstraints = GridPanel.copy(this.constraints);
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        this.constraints.anchor = ANCHOR_MAP.getForward(anchor);
        this.constraints.fill = FILL_MAP.getForward(fill);
        this.constraints.insets = insets;
        this.constraints.ipadx = n5;
        this.constraints.ipady = n6;
        this.constraints.weightx = d;
        this.constraints.weighty = d2;
        super.add(component, this.constraints);
        GridPanel.setConstraints(gridBagConstraints, this.constraints);
    }

    public void add(Component component, int n, int n2) {
        this.add(component, n2, n, this.getGridWidth(), this.getGridHeight(), this.getWeightX(), this.getWeightY(), this.getAnchor(), this.getFill(), this.getInsetsReference(), this.getInternalPaddingX(), this.getInternalPaddingY());
    }

    public void add(Component component, int n, int n2, Anchor anchor) {
        this.add(component, n2, n, this.getGridWidth(), this.getGridHeight(), this.getWeightX(), this.getWeightY(), anchor, this.getFill(), this.getInsetsReference(), this.getInternalPaddingX(), this.getInternalPaddingY());
    }

    public void add(Component component, int n, int n2, Fill fill) {
        this.add(component, n2, n, this.getGridWidth(), this.getGridHeight(), this.getWeightX(), this.getWeightY(), this.getAnchor(), fill, this.getInsetsReference(), this.getInternalPaddingX(), this.getInternalPaddingY());
    }

    private static GridBagConstraints copy(GridBagConstraints gridBagConstraints) {
        return new GridBagConstraints(gridBagConstraints.gridx, gridBagConstraints.gridy, gridBagConstraints.gridwidth, gridBagConstraints.gridheight, gridBagConstraints.weightx, gridBagConstraints.weighty, gridBagConstraints.anchor, gridBagConstraints.fill, gridBagConstraints.insets, gridBagConstraints.ipadx, gridBagConstraints.ipady);
    }

    private static void setConstraints(GridBagConstraints gridBagConstraints, GridBagConstraints gridBagConstraints2) {
        gridBagConstraints2.gridx = gridBagConstraints.gridx;
        gridBagConstraints2.gridy = gridBagConstraints.gridy;
        gridBagConstraints2.gridwidth = gridBagConstraints.gridwidth;
        gridBagConstraints2.gridheight = gridBagConstraints.gridheight;
        gridBagConstraints2.weightx = gridBagConstraints.weightx;
        gridBagConstraints2.weighty = gridBagConstraints.weighty;
        gridBagConstraints2.anchor = gridBagConstraints.anchor;
        gridBagConstraints2.fill = gridBagConstraints.fill;
        gridBagConstraints2.insets = gridBagConstraints.insets;
        gridBagConstraints2.ipadx = gridBagConstraints.ipadx;
        gridBagConstraints2.ipady = gridBagConstraints.ipady;
    }

    public void setGridX(int n) {
        this.constraints.gridx = n;
    }

    public int getGridWidth() {
        return this.constraints.gridwidth;
    }

    public int getGridHeight() {
        return this.constraints.gridheight;
    }

    public double getWeightX() {
        return this.constraints.weightx;
    }

    public double getWeightY() {
        return this.constraints.weighty;
    }

    public void setAnchor(Anchor anchor) {
        this.constraints.anchor = ANCHOR_MAP.getForward(anchor);
    }

    public Anchor getAnchor() {
        return ANCHOR_MAP.getReverse(this.constraints.anchor);
    }

    public void setFill(Fill fill) {
        this.constraints.fill = FILL_MAP.getForward(fill);
    }

    public Fill getFill() {
        return FILL_MAP.getReverse(this.constraints.fill);
    }

    public void setInsets(Insets insets) {
        this.constraints.insets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    private Insets getInsetsReference() {
        return this.constraints.insets;
    }

    public int getInternalPaddingX() {
        return this.constraints.ipadx;
    }

    public int getInternalPaddingY() {
        return this.constraints.ipady;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Anchor
    extends Enum<Anchor> {
        public static final /* enum */ Anchor CENTER = new Anchor();
        public static final /* enum */ Anchor NORTH = new Anchor();
        public static final /* enum */ Anchor NORTHEAST = new Anchor();
        public static final /* enum */ Anchor EAST = new Anchor();
        public static final /* enum */ Anchor SOUTHEAST = new Anchor();
        public static final /* enum */ Anchor SOUTH = new Anchor();
        public static final /* enum */ Anchor SOUTHWEST = new Anchor();
        public static final /* enum */ Anchor WEST = new Anchor();
        public static final /* enum */ Anchor NORTHWEST = new Anchor();
        public static final /* enum */ Anchor PAGE_START = new Anchor();
        public static final /* enum */ Anchor PAGE_END = new Anchor();
        public static final /* enum */ Anchor LINE_START = new Anchor();
        public static final /* enum */ Anchor LINE_END = new Anchor();
        public static final /* enum */ Anchor FIRST_LINE_START = new Anchor();
        public static final /* enum */ Anchor FIRST_LINE_END = new Anchor();
        public static final /* enum */ Anchor LAST_LINE_START = new Anchor();
        public static final /* enum */ Anchor LAST_LINE_END = new Anchor();
        private static final /* synthetic */ Anchor[] $VALUES;

        public static Anchor[] values() {
            return (Anchor[])$VALUES.clone();
        }

        static {
            $VALUES = new Anchor[]{CENTER, NORTH, NORTHEAST, EAST, SOUTHEAST, SOUTH, SOUTHWEST, WEST, NORTHWEST, PAGE_START, PAGE_END, LINE_START, LINE_END, FIRST_LINE_START, FIRST_LINE_END, LAST_LINE_START, LAST_LINE_END};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Fill
    extends Enum<Fill> {
        public static final /* enum */ Fill HORIZONTAL = new Fill();
        public static final /* enum */ Fill VERTICAL = new Fill();
        public static final /* enum */ Fill BOTH = new Fill();
        public static final /* enum */ Fill NONE = new Fill();
        private static final /* synthetic */ Fill[] $VALUES;

        public static Fill[] values() {
            return (Fill[])$VALUES.clone();
        }

        static {
            $VALUES = new Fill[]{HORIZONTAL, VERTICAL, BOTH, NONE};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TwoWayMap<T, U> {
        private HashMap<T, U> forward = new HashMap();
        private HashMap<U, T> reverse = new HashMap();

        private TwoWayMap() {
        }

        public void put(T t, U u) {
            this.forward.put(t, u);
            this.reverse.put(u, t);
        }

        public int size() {
            assert (this.forward.size() == this.reverse.size());
            return this.forward.size();
        }

        public U getForward(T t) {
            return this.forward.get(t);
        }

        public T getReverse(U u) {
            return this.reverse.get(u);
        }
    }
}

