/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.graphics.transforms;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

public class ModelViewTransform {
    private AffineTransform transform;

    private ModelViewTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
    }

    public static ModelViewTransform createOffsetScaleMapping(Point2D point2D, double d, double d2) {
        return new ModelViewTransform(new AffineTransform(d, 0.0, 0.0, d2, point2D.getX(), point2D.getY()));
    }

    public Point2D modelToView(Point2D point2D) {
        return this.transform.transform(point2D, null);
    }

    public Vector2D modelToView(Vector2D vector2D) {
        return new Vector2D(this.transform.transform(vector2D.toPoint2D(), null));
    }

    public Point2D modelToViewDelta(Point2D point2D) {
        return this.transform.deltaTransform(point2D, null);
    }

    public double modelToViewX(double d) {
        return this.modelToView(new Point2D.Double(d, 0.0)).getX();
    }

    public double modelToViewY(double d) {
        return this.modelToView(0.0, d).getY();
    }

    public Point2D modelToView(double d, double d2) {
        return this.modelToView(new Point2D.Double(d, d2));
    }

    public double modelToViewDeltaX(double d) {
        return this.modelToViewDelta(new Point2D.Double(d, 0.0)).getX();
    }

    public double modelToViewDeltaY(double d) {
        return this.modelToViewDelta(new Point2D.Double(0.0, d)).getY();
    }

    public Point2D viewToModel(Point2D point2D) {
        return this.getInverseTransform().transform(point2D, null);
    }

    public Vector2D viewToModel(Vector2D vector2D) {
        return new Vector2D(this.viewToModel(vector2D.toPoint2D()));
    }

    public Point2D viewToModelDelta(Point2D point2D) {
        return this.getInverseTransform().deltaTransform(point2D, null);
    }

    protected AffineTransform getInverseTransform() {
        try {
            return this.transform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new RuntimeException(noninvertibleTransformException);
        }
    }

    public double viewToModelDeltaX(double d) {
        return this.viewToModelDelta(new Point2D.Double(d, 0.0)).getX();
    }

    public double viewToModelDeltaY(double d) {
        return this.viewToModelDelta(new Point2D.Double(0.0, d)).getY();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.transform.equals(((ModelViewTransform)object).transform);
    }

    public int hashCode() {
        return this.transform.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.transform.toString();
    }
}

