/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util;

import edu.colorado.phet.common.phetcommon.util.ObserverList;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableList<T>
implements List<T> {
    private final List<T> list = new ArrayList<T>();
    private final ObserverList<T> elementAddedObservers = new ObserverList();
    private final ObserverList<T> elementRemovedObservers = new ObserverList();
    private final IdentityHashMap<T, ArrayList<VoidFunction0>> particularElementRemovedObservers = new IdentityHashMap();

    public ObservableList() {
    }

    public ObservableList(Collection<? extends T> collection) {
        this.list.addAll(collection);
    }

    public ObservableList(T[] TArray) {
        this.list.addAll(Arrays.asList(TArray));
    }

    public void addElementAddedObserver(VoidFunction1<T> voidFunction1) {
        this.addElementAddedObserver(voidFunction1, true);
    }

    public void addElementAddedObserver(VoidFunction1<T> voidFunction1, boolean bl) {
        this.elementAddedObservers.addObserver(voidFunction1);
        if (bl) {
            for (T t : this.list) {
                voidFunction1.apply(t);
            }
        }
    }

    public void addElementRemovedObserver(VoidFunction1<T> voidFunction1) {
        this.elementRemovedObservers.addObserver(voidFunction1);
    }

    @Override
    public boolean add(T t) {
        boolean bl = this.list.add(t);
        this.elementAddedObservers.notifyObservers(t);
        return bl;
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = this.list.remove(object);
        if (bl) {
            this.elementRemovedObservers.notifyObservers(object);
        }
        if (this.particularElementRemovedObservers.containsKey(object) && bl) {
            for (VoidFunction0 voidFunction0 : new ArrayList(this.particularElementRemovedObservers.get(object))) {
                voidFunction0.apply();
            }
        }
        return bl;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        for (T t : collection) {
            this.add(t);
        }
        return true;
    }

    @Override
    public boolean addAll(int n, Collection<? extends T> collection) {
        boolean bl = this.list.addAll(n, collection);
        for (T t : collection) {
            this.elementAddedObservers.notifyObservers(t);
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            boolean bl2 = this.remove(obj);
            bl = bl || bl2;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        for (Object e : new ArrayList(this)) {
            if (collection.contains(e)) continue;
            boolean bl2 = this.remove(e);
            bl = bl || bl2;
        }
        return bl;
    }

    @Override
    public void clear() {
        while (this.size() > 0) {
            this.remove(0);
        }
    }

    @Override
    public void add(int n, T t) {
        this.list.add(n, t);
        this.elementAddedObservers.notifyObservers(t);
    }

    @Override
    public T remove(int n) {
        T t = this.get(n);
        this.remove(t);
        return t;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.list.contains(object);
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.list.toArray(TArray);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ObservableList observableList = (ObservableList)object;
        return ((Object)this.list).equals(observableList.list);
    }

    @Override
    public int hashCode() {
        return ((Object)this.list).hashCode();
    }

    @Override
    public T get(int n) {
        return this.list.get(n);
    }

    @Override
    public T set(int n, T t) {
        return this.list.set(n, t);
    }

    @Override
    public int indexOf(Object object) {
        return this.list.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.list.lastIndexOf(object);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int n) {
        return this.listIterator(n);
    }

    @Override
    public List<T> subList(int n, int n2) {
        return this.list.subList(n, n2);
    }

    public String toString() {
        return this.list.toString();
    }

    public String mkString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            stringBuffer.append(this.get(i));
            if (i >= this.size() - 1) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

