/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.games;

import edu.colorado.phet.common.games.GameSimSharing;
import edu.colorado.phet.common.games.GameTimerFormat;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ModelComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class GameOverNode
extends PhetPNode {
    private static final String TITLE_GAME_OVER = PhetCommonResources.getString("Games.title.gameOver");
    private static final String BUTTON_NEW_GAME = PhetCommonResources.getString("Games.button.newGame");
    private static final String LABEL_LEVEL = PhetCommonResources.getString("Games.label.level");
    private static final String LABEL_SCORE_IMPERFECT = PhetCommonResources.getString("Games.label.score.max");
    private static final String LABEL_SCORE_PERFECT = PhetCommonResources.getString("Games.label.score.max.perfect");
    private static final String LABEL_TIME = PhetCommonResources.getString("Games.label.time");
    private static final String LABEL_BEST = PhetCommonResources.getString("Games.label.best");
    private static final String LABEL_NEW_BEST = PhetCommonResources.getString("Games.label.newBest");
    private static final String FORMAT_TIME_BEST = PhetCommonResources.getString("Games.format.time.best");
    private static final Font TITLE_FONT = new PhetFont(24);
    private static final Font LABEL_FONT = new PhetFont(18);
    private static final Color BACKGROUND_FILL_COLOR = new Color(180, 205, 255);
    private static final Color BACKGROUND_STROKE_COLOR = Color.BLACK;
    private static final Stroke BACKGROUND_STROKE = new BasicStroke(1.0f);
    private final NumberFormat scoreFormat;
    private final EventListenerList listeners;

    public GameOverNode(int n, double d, double d2, NumberFormat numberFormat, long l, long l2, boolean bl, boolean bl2, Color color) {
        SimSharingManager.sendModelMessage(GameSimSharing.ModelComponents.game, ModelComponentTypes.feature, GameSimSharing.ModelActions.completed, ParameterSet.parameterSet((IParameterKey)GameSimSharing.ParameterKeys.level, n).with((IParameterKey)GameSimSharing.ParameterKeys.score, d).with((IParameterKey)GameSimSharing.ParameterKeys.perfectScore, d2).with((IParameterKey)GameSimSharing.ParameterKeys.time, l).with((IParameterKey)GameSimSharing.ParameterKeys.bestTime, l2).with((IParameterKey)GameSimSharing.ParameterKeys.isNewBestTime, bl).with((IParameterKey)GameSimSharing.ParameterKeys.timerVisible, bl2));
        this.scoreFormat = numberFormat;
        this.listeners = new EventListenerList();
        PText pText = new PText(TITLE_GAME_OVER);
        pText.setFont(TITLE_FONT);
        this.addChild(pText);
        PText pText2 = new PText(GameOverNode.getLevelString(n));
        pText2.setFont(LABEL_FONT);
        this.addChild(pText2);
        PText pText3 = new PText(this.getScoreString(d, d2));
        pText3.setFont(LABEL_FONT);
        this.addChild(pText3);
        boolean bl3 = d == d2;
        PText pText4 = new PText(GameOverNode.getTimeString(l, l2, bl2, bl3, bl));
        pText4.setFont(LABEL_FONT);
        this.addChild(pText4);
        HTMLImageButtonNode hTMLImageButtonNode = new HTMLImageButtonNode(BUTTON_NEW_GAME, color){
            {
                this.setUserComponent(GameSimSharing.UserComponents.newGameButton);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        GameOverNode.this.fireNewGamePressed();
                    }
                });
            }
        };
        this.addChild(hTMLImageButtonNode);
        double d3 = Math.max(PNodeLayoutUtils.getMaxFullWidthChildren(this), 175.0);
        PPath pPath = new PPath(new Line2D.Double(0.0, 0.0, d3, 0.0));
        this.addChild(pPath);
        PPath pPath2 = new PPath(new Line2D.Double(0.0, 0.0, d3, 0.0));
        this.addChild(pPath2);
        double d4 = d3 + 50.0;
        double d5 = PNodeLayoutUtils.sumFullHeightsChildren(this) + 15.0 * (double)(this.getChildrenCount() - 1) + 30.0;
        PPath pPath3 = new PPath(new Rectangle2D.Double(0.0, 0.0, d4, d5));
        pPath3.setStroke(BACKGROUND_STROKE);
        pPath3.setStrokePaint(BACKGROUND_STROKE_COLOR);
        pPath3.setPaint(BACKGROUND_FILL_COLOR);
        this.addChild(pPath3);
        pPath3.moveToBack();
        double d6 = 0.0;
        double d7 = 0.0;
        pPath3.setOffset(d6, d7);
        d6 = (pPath3.getFullBoundsReference().getWidth() - pText.getFullBoundsReference().getWidth()) / 2.0;
        d7 = pPath3.getFullBoundsReference().getMinY() + 15.0;
        pText.setOffset(d6, d7);
        d6 = (pPath3.getFullBoundsReference().getWidth() - pPath.getFullBoundsReference().getWidth()) / 2.0;
        d7 = pText.getFullBoundsReference().getMaxY() + 15.0;
        pPath.setOffset(d6, d7);
        d7 = pPath.getFullBoundsReference().getMaxY() + 15.0;
        pText2.setOffset(d6, d7);
        d7 = pText2.getFullBoundsReference().getMaxY() + 15.0;
        pText3.setOffset(d6, d7);
        d7 = pText3.getFullBoundsReference().getMaxY() + 15.0;
        pText4.setOffset(d6, d7);
        d7 = pText4.getFullBoundsReference().getMaxY() + 15.0;
        pPath2.setOffset(d6, d7);
        d6 = (pPath3.getFullBoundsReference().getWidth() - hTMLImageButtonNode.getFullBoundsReference().getWidth()) / 2.0;
        d7 = pPath2.getFullBoundsReference().getMaxY() + 15.0;
        hTMLImageButtonNode.setOffset(d6, d7);
    }

    private static String getLevelString(int n) {
        return MessageFormat.format(LABEL_LEVEL, String.valueOf(n));
    }

    private String getScoreString(double d, double d2) {
        String string = this.scoreFormat.format(d);
        String string2 = this.scoreFormat.format(d2);
        String string3 = null;
        string3 = d == d2 ? MessageFormat.format(LABEL_SCORE_PERFECT, string, string2) : MessageFormat.format(LABEL_SCORE_IMPERFECT, string, string2);
        return string3;
    }

    private static String getTimeString(long l, long l2, boolean bl, boolean bl2, boolean bl3) {
        String string = " ";
        if (bl) {
            String string2 = MessageFormat.format(LABEL_TIME, GameTimerFormat.format(l));
            if (!bl2) {
                string = string2;
            } else if (bl3) {
                string = MessageFormat.format(FORMAT_TIME_BEST, string2, LABEL_NEW_BEST);
            } else {
                String string3 = MessageFormat.format(LABEL_BEST, GameTimerFormat.format(l2));
                string = MessageFormat.format(FORMAT_TIME_BEST, string2, string3);
            }
        }
        return string;
    }

    public void addGameOverListener(GameOverListener gameOverListener) {
        this.listeners.add(GameOverListener.class, gameOverListener);
    }

    private void fireNewGamePressed() {
        for (GameOverListener gameOverListener : (GameOverListener[])this.listeners.getListeners(GameOverListener.class)) {
            gameOverListener.newGamePressed();
        }
    }

    public static interface GameOverListener
    extends EventListener {
        public void newGamePressed();
    }
}

