/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.quantum.model.Tube;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;

public class TubeGraphic
extends CompositePhetGraphic
implements Tube.ChangeListener {
    private Ellipse2D end1 = new Ellipse2D.Double();
    private Ellipse2D end2 = new Ellipse2D.Double();
    private Line2D top = new Line2D.Double();
    private Line2D bottom = new Line2D.Double();
    private Rectangle bounds = new Rectangle();
    private Tube cavity;
    private Stroke stroke = new BasicStroke(1.5f);
    private Color color = Color.black;

    public TubeGraphic(Component component, Tube tube) {
        super(component);
        this.cavity = tube;
        this.addGraphic(new PhetShapeGraphic(component, this.end1, this.stroke, this.color));
        this.addGraphic(new PhetShapeGraphic(component, this.end2, this.stroke, this.color));
        this.addGraphic(new PhetShapeGraphic(component, this.top, this.stroke, this.color));
        this.addGraphic(new PhetShapeGraphic(component, this.bottom, this.stroke, this.color));
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        tube.addListener(this);
        this.update();
    }

    protected Rectangle determineBounds() {
        return this.bounds;
    }

    public void update() {
        double d = 15.0;
        this.top.setLine(this.cavity.getMinX(), this.cavity.getMinY(), this.cavity.getMinX() + this.cavity.getWidth(), this.cavity.getMinY());
        this.bottom.setLine(this.cavity.getMinX(), this.cavity.getMaxY(), this.cavity.getMinX() + this.cavity.getWidth(), this.cavity.getMaxY());
        this.end1.setFrame(this.cavity.getMinX() - d / 2.0, this.cavity.getMinY(), d, this.cavity.getHeight());
        this.end2.setFrame(this.cavity.getMinX() + this.cavity.getWidth() - d / 2.0, this.cavity.getMinY(), d, this.cavity.getHeight());
        this.bounds.setRect(this.end1.getMinX(), this.end1.getMinY(), this.end2.getMaxX() - this.end1.getMinX(), this.end2.getMaxY() - this.end1.getMinY());
    }
}

