/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetcommon.view.util.MakeDuotoneImageOp;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.quantum.model.Beam;
import edu.colorado.phet.common.quantum.model.PhotonSource;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.EventListener;
import java.util.EventObject;

public class LampGraphic
extends CompositePhetGraphic
implements PhotonSource.WavelengthChangeListener {
    private Beam beam;
    private double currWavelength;
    private BasicStroke bezelStroke = new BasicStroke(2.0f);
    private Ellipse2D lens;
    private PhetShapeGraphic lensGraphic;
    private EventChannel changeEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeEventChannel.getListenerProxy();

    public LampGraphic(Beam beam, Component component, BufferedImage bufferedImage, AffineTransform affineTransform) {
        super(component);
        this.setTransform(affineTransform);
        this.beam = beam;
        beam.addWavelengthChangeListener(this);
        PhetImageGraphic phetImageGraphic = new PhetImageGraphic(component, bufferedImage);
        this.addGraphic(phetImageGraphic);
        double d = phetImageGraphic.getImage().getHeight();
        double d2 = phetImageGraphic.getImage().getHeight() / 8;
        this.lens = new Ellipse2D.Double((double)phetImageGraphic.getImage().getWidth() - d2 / 2.0 - 3.0, 0.0, d2, d);
        this.lensGraphic = new PhetShapeGraphic(component, this.lens, this.bezelStroke, Color.black);
        this.addGraphic(this.lensGraphic);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this.update();
    }

    public void wavelengthChanged(PhotonSource.WavelengthChangeEvent wavelengthChangeEvent) {
        this.update();
    }

    private void update() {
        if (this.currWavelength != this.beam.getWavelength()) {
            this.currWavelength = this.beam.getWavelength();
            Color color = VisibleColor.wavelengthToColor(this.currWavelength);
            color = LampGraphic.getDuotone(color);
            this.lensGraphic.setColor(color);
            this.repaint();
        }
    }

    public static Color getDuotone(Color color) {
        double d = MakeDuotoneImageOp.getGrayLevel(color);
        int n = MakeDuotoneImageOp.getDuoToneRGB(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), d, color);
        return new Color(n);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.changeListenerProxy.changed(new ChangeEvent(this));
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.addListener(changeListener);
    }

    public class ChangeEvent
    extends EventObject {
        public ChangeEvent(Object object) {
            super(object);
        }

        public LampGraphic getLampGraphic() {
            return (LampGraphic)this.getSource();
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void changed(ChangeEvent var1);
    }
}

