/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.ModelViewTransform1D;
import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationEvent;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationListener;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic2;
import edu.colorado.phet.common.quantum.QuantumConfig;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.Beam;
import edu.colorado.phet.lasers.LasersResources;
import edu.colorado.phet.lasers.view.EnergyMatchDetector;
import edu.colorado.phet.lasers.view.LevelIcon;
import edu.colorado.phet.lasers.view.MatchState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.event.MouseInputAdapter;

public class EnergyLevelGraphic
extends CompositePhetGraphic
implements EnergyMatchDetector.Listener {
    private AtomicState atomicState;
    private double groundStateEnergy;
    private boolean isAdjustable;
    private double iconLocX;
    private boolean clampTopWorkaround;
    private Color color;
    private double x;
    private double width;
    private EnergyLevelRep energyLevelRep;
    private ModelViewTransform1D energyYTx;
    private boolean arrowsEnabled = true;
    private int minPixelsBetweenLevels = 25;
    private ColorStrategy colorStrategy = new VisibleColorStrategy();
    private LevelIcon levelIcon;
    public static boolean showLifetimeLabelText = true;
    HashMap matchTable = new HashMap();
    public static final ArrayList instances = new ArrayList();

    public EnergyLevelGraphic(Component component, AtomicState atomicState, double d, double d2, double d3, boolean bl, double d4, boolean bl2) {
        super(null);
        this.atomicState = atomicState;
        this.groundStateEnergy = d;
        this.isAdjustable = bl;
        this.iconLocX = d4;
        this.clampTopWorkaround = bl2;
        atomicState.addListener(new AtomicStateChangeListener());
        this.x = d2;
        this.width = d3;
        this.energyLevelRep = new EnergyLevelRep(component);
        this.addGraphic(this.energyLevelRep);
        if (this.isAdjustable) {
            this.setCursorHand();
            this.addTranslationListener(new EnergyLevelTranslator());
            this.addMouseInputListener(new MouseInputAdapter(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    EnergyLevelGraphic.this.handleSnapTo();
                }
            });
        }
    }

    private void handleSnapTo() {
        Set set = this.matchTable.keySet();
        for (Beam beam : set) {
            MatchState matchState = (MatchState)this.matchTable.get(beam);
            if (!matchState.isMatch()) continue;
            this.setEnergy(matchState.getMatchingEnergy());
            break;
        }
    }

    public void setTransform(ModelViewTransform1D modelViewTransform1D) {
        this.energyYTx = modelViewTransform1D;
        this.energyLevelRep.update();
    }

    public Point2D getPosition() {
        return this.energyLevelRep.getBounds().getLocation();
    }

    public Point2D getLinePosition() {
        return this.energyLevelRep.getLinePosition();
    }

    public void setLevelIcon(LevelIcon levelIcon) {
        this.levelIcon = levelIcon;
        levelIcon.setCursorHand();
        this.energyLevelRep.setLevelIcon(levelIcon);
    }

    public void putMatch(Beam beam, MatchState matchState) {
        this.matchTable.put(beam, matchState);
        this.energyLevelRep.update();
        this.repaint();
    }

    public long getLastMatchTime() {
        Set set = this.matchTable.keySet();
        long l = 0L;
        for (Object k : set) {
            MatchState matchState = (MatchState)this.matchTable.get(k);
            if (!matchState.isMatch() || matchState.getTime() <= l) continue;
            l = matchState.getTime();
        }
        return l;
    }

    public static void setBlinkRenderer(Color color) {
        for (int i = 0; i < instances.size(); ++i) {
            EnergyLevelRep energyLevelRep = (EnergyLevelRep)instances.get(i);
            energyLevelRep.setBlinkRenderer(color);
        }
    }

    public static void setFlowRenderer() {
        for (int i = 0; i < instances.size(); ++i) {
            EnergyLevelRep energyLevelRep = (EnergyLevelRep)instances.get(i);
            energyLevelRep.setFlowRenderer();
        }
    }

    private void setEnergy(double d) {
        this.atomicState.setEnergyLevel(d);
        this.atomicState.determineEmittedPhotonWavelength();
        this.levelIcon.updateEnergy(d);
    }

    private class AtomicStateChangeListener
    extends AtomicState.ChangeListenerAdapter {
        private AtomicStateChangeListener() {
        }

        public void energyLevelChanged(AtomicState.Event event) {
            EnergyLevelGraphic.this.energyLevelRep.update();
            EnergyLevelGraphic.this.levelIcon.updateEnergy(event.getEnergy());
        }
    }

    public static interface ColorStrategy {
        public Color getColor(AtomicState var1, double var2);
    }

    public class EnergyLevelRep
    extends CompositePhetGraphic {
        private Rectangle2D energyLevelShape;
        private double height;
        private Arrow arrow1;
        private Arrow arrow2;
        private Rectangle boundingRect;
        private LevelIcon levelIcon;
        private PhetTextGraphic2 textGraphic;
        RenderStrategy strategy;

        protected EnergyLevelRep(Component component) {
            super(component);
            this.energyLevelShape = new Rectangle2D.Double();
            this.height = 2.0;
            this.strategy = new Blink(QuantumConfig.BLINK_LINE_COLOR);
            PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(component, this.energyLevelShape, EnergyLevelGraphic.this.color);
            phetShapeGraphic.setVisible(true);
            this.addGraphic(phetShapeGraphic);
            instances.add(this);
        }

        public void setRenderer(RenderStrategy renderStrategy) {
            this.strategy = renderStrategy;
            this.update();
        }

        private void update() {
            EnergyLevelGraphic.this.color = EnergyLevelGraphic.this.colorStrategy.getColor(EnergyLevelGraphic.this.atomicState, EnergyLevelGraphic.this.groundStateEnergy);
            EnergyLevelGraphic.this.color = new Color(EnergyLevelGraphic.this.color.getRed(), EnergyLevelGraphic.this.color.getGreen(), EnergyLevelGraphic.this.color.getBlue());
            int n = EnergyLevelGraphic.this.energyYTx.modelToView(EnergyLevelGraphic.this.atomicState.getEnergyLevel());
            this.energyLevelShape.setRect(EnergyLevelGraphic.this.x, n, EnergyLevelGraphic.this.width, this.height);
            if (this.levelIcon != null) {
                this.levelIcon.setLocation((int)EnergyLevelGraphic.this.iconLocX, (int)((double)n - this.height));
            }
            if (EnergyLevelGraphic.this.isAdjustable) {
                double d = EnergyLevelGraphic.this.width - 30.0;
                int n2 = 16;
                int n3 = 10;
                int n4 = 3;
                this.arrow1 = new Arrow(new Point2D.Double(EnergyLevelGraphic.this.x + d, n), new Point2D.Double(EnergyLevelGraphic.this.x + d, n + n2), n3, n3, n4);
                this.arrow2 = new Arrow(new Point2D.Double(EnergyLevelGraphic.this.x + d, n), new Point2D.Double(EnergyLevelGraphic.this.x + d, n - n2), n3, n3, n4);
            }
            if (this.textGraphic != null) {
                this.textGraphic.setLocation((int)(EnergyLevelGraphic.this.iconLocX + (double)(this.levelIcon.getWidth() / 2)), (int)this.energyLevelShape.getY() - this.textGraphic.getHeight() / 2 - 25 - 3);
            }
            this.boundingRect = this.determineBoundsInternal();
            this.setBoundsDirty();
            this.repaint();
        }

        protected Rectangle determineBounds() {
            return this.boundingRect;
        }

        private Rectangle determineBoundsInternal() {
            if (this.arrow1 != null && EnergyLevelGraphic.this.arrowsEnabled) {
                Area area = new Area(this.arrow1.getShape());
                area.add(new Area(this.arrow2.getShape()));
                area.add(new Area(this.energyLevelShape));
                return area.getBounds();
            }
            return this.energyLevelShape.getBounds();
        }

        void setLevelIcon(LevelIcon levelIcon) {
            this.levelIcon = levelIcon;
            this.addGraphic(levelIcon);
            if (EnergyLevelGraphic.this.isAdjustable && showLifetimeLabelText) {
                this.textGraphic = new PhetTextGraphic2(this.getComponent(), new PhetFont(PhetFont.getDefaultFontSize(), true), LasersResources.getString("EnergyLevelMonitorPanel.sliderLabel"), Color.black);
                this.addGraphic(this.textGraphic);
            }
        }

        public boolean contains(int n, int n2) {
            return this.boundingRect.contains(n, n2) || this.levelIcon.contains(n, n2);
        }

        public void paint(Graphics2D graphics2D) {
            this.saveGraphicsState(graphics2D);
            this.strategy.render(graphics2D);
            super.paint(graphics2D);
            this.restoreGraphicsState();
        }

        public Point2D getLinePosition() {
            return this.energyLevelShape.getBounds().getLocation();
        }

        public void setBlinkRenderer(Color color) {
            this.setRenderer(new Blink(color));
        }

        public void setFlowRenderer() {
            this.setRenderer(new FlowLine());
        }

        public class Blink
        implements RenderStrategy {
            Color targetColor;

            public Blink(Color color) {
                this.targetColor = color;
            }

            public void render(Graphics2D graphics2D) {
                if (EnergyLevelGraphic.this.isAdjustable && EnergyLevelGraphic.this.arrowsEnabled) {
                    graphics2D.setColor(Color.DARK_GRAY);
                    graphics2D.draw(EnergyLevelRep.this.arrow1.getShape());
                    graphics2D.draw(EnergyLevelRep.this.arrow2.getShape());
                }
                boolean bl = System.currentTimeMillis() / 100L % 2L == 0L;
                long l = EnergyLevelGraphic.this.getLastMatchTime();
                if (System.currentTimeMillis() - l > 750L) {
                    bl = false;
                }
                graphics2D.setColor(bl ? this.targetColor : EnergyLevelGraphic.this.color);
                if (System.currentTimeMillis() - l < 750L) {
                    EnergyLevelRep.this.levelIcon.setVisible(!bl);
                } else {
                    EnergyLevelRep.this.levelIcon.setVisible(true);
                }
                graphics2D.fill(EnergyLevelRep.this.energyLevelShape);
            }
        }

        public class FlowLine
        implements RenderStrategy {
            float phase = 0.0f;

            public void render(Graphics2D graphics2D) {
                if (EnergyLevelGraphic.this.isAdjustable && EnergyLevelGraphic.this.arrowsEnabled) {
                    graphics2D.setColor(Color.DARK_GRAY);
                    graphics2D.draw(EnergyLevelRep.this.arrow1.getShape());
                    graphics2D.draw(EnergyLevelRep.this.arrow2.getShape());
                }
                graphics2D.setColor(EnergyLevelGraphic.this.color);
            }
        }
    }

    private class EnergyLevelTranslator
    implements TranslationListener {
        private EnergyLevelTranslator() {
        }

        public void translationOccurred(TranslationEvent translationEvent) {
            int n = translationEvent.getDy();
            double d = EnergyLevelGraphic.this.energyYTx.viewToModelDifferential(n);
            double d2 = EnergyLevelGraphic.this.energyYTx.viewToModelDifferential(-EnergyLevelGraphic.this.minPixelsBetweenLevels);
            double d3 = EnergyLevelGraphic.this.atomicState.getNextHigherEnergyState().getEnergyLevel() - d2;
            double d4 = EnergyLevelGraphic.this.atomicState.getNextLowerEnergyState().getEnergyLevel() + d2;
            double d5 = EnergyLevelGraphic.this.atomicState.getEnergyLevel() + d;
            double d6 = MathUtil.clamp(d4, d5, d3);
            double d7 = PhysicsUtil.wavelengthToEnergy(380.0) + EnergyLevelGraphic.this.groundStateEnergy;
            if (EnergyLevelGraphic.this.clampTopWorkaround) {
                d6 = Math.min(d6, d7);
            }
            EnergyLevelGraphic.this.setEnergy(d6);
        }
    }

    public static interface RenderStrategy {
        public void render(Graphics2D var1);
    }

    public static class VisibleColorStrategy
    implements ColorStrategy {
        public Color getColor(AtomicState atomicState, double d) {
            double d2 = atomicState.getEnergyLevel() - d;
            return VisibleColor.wavelengthToColor(PhysicsUtil.energyToWavelength(d2));
        }
    }
}

