/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.lasers.model.LaserModel;
import edu.colorado.phet.lasers.view.AnnotatedAtomGraphic;
import edu.colorado.phet.lasers.view.PhotonGraphic;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class AbstractLegend
extends JPanel {
    private GridBagConstraints iconGbc = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 60, 5, 10), 0, 0);
    private GridBagConstraints labelGbc = new GridBagConstraints(1, -1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 5, 10), 0, 0);

    public AbstractLegend(String string) {
        super(new GridBagLayout());
        this.setBorder(new TitledBorder(string));
    }

    protected BufferedImage getPhotonImage(double d) {
        Photon photon = new Photon(d, new Point2D.Double(), new Vector2D());
        return PhotonGraphic.getInstance(this, photon).getImage();
    }

    public void addLegendItem(Image image, String string) {
        this.add((Component)new JLabel(new ImageIcon(image)), this.iconGbc);
        this.add((Component)new JLabel(string), this.labelGbc);
    }

    protected BufferedImage createPhotonLegendImage() {
        return this.append(new BufferedImage[]{this.getPhotonImage(680.0), this.getPhotonImage(470.0), this.getPhotonImage(800.0)});
    }

    private BufferedImage append(BufferedImage[] bufferedImageArray) {
        Object object;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < bufferedImageArray.length; ++i) {
            object = bufferedImageArray[i];
            n += ((BufferedImage)object).getWidth();
            n2 = Math.max(n2, ((BufferedImage)object).getHeight());
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, bufferedImageArray[0].getType());
        object = bufferedImage.createGraphics();
        int n3 = 0;
        for (int i = 0; i < bufferedImageArray.length; ++i) {
            ((Graphics2D)object).drawRenderedImage(bufferedImageArray[i], AffineTransform.getTranslateInstance(n3, 0.0));
            n3 += bufferedImageArray[i].getWidth();
        }
        return bufferedImage;
    }

    protected BufferedImage getAtomImage() {
        LaserModel laserModel = new LaserModel(1.0);
        Atom atom = new Atom(laserModel, 3);
        atom.setStates(new AtomicState[]{laserModel.getGroundState(), laserModel.getMiddleEnergyState(), laserModel.getHighEnergyState()});
        atom.setCurrState(laserModel.getGroundState());
        AnnotatedAtomGraphic annotatedAtomGraphic = new AnnotatedAtomGraphic(this, atom);
        BufferedImage bufferedImage = new BufferedImage(annotatedAtomGraphic.getWidth(), annotatedAtomGraphic.getHeight(), 3);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.translate(annotatedAtomGraphic.getWidth() / 2, annotatedAtomGraphic.getHeight() / 2);
        graphics2D.scale(0.8, 0.8);
        annotatedAtomGraphic.paint(graphics2D);
        return bufferedImage;
    }
}

