/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.controller.module;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.Beam;
import edu.colorado.phet.common.quantum.model.ElementProperties;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.lasers.LasersApplication;
import edu.colorado.phet.lasers.LasersConfig;
import edu.colorado.phet.lasers.LasersResources;
import edu.colorado.phet.lasers.controller.BeamControl;
import edu.colorado.phet.lasers.controller.UniversalLaserControlPanel;
import edu.colorado.phet.lasers.controller.module.BaseLaserModule;
import edu.colorado.phet.lasers.model.LaserModel;
import edu.colorado.phet.lasers.model.atom.LaserAtom;
import edu.colorado.phet.lasers.model.atom.TwoLevelElementProperties;
import edu.colorado.phet.lasers.view.LampGraphic;
import java.awt.Component;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class SingleAtomModule
extends BaseLaserModule {
    private Atom atom;
    private LampGraphic pumpingLampGraphic;
    private UniversalLaserControlPanel laserControlPanel;
    private BeamControl pumpBeamControl;
    private BeamControl seedBeamControl;

    public SingleAtomModule(PhetFrame phetFrame, IClock iClock) {
        super(phetFrame, LasersResources.getString("ModuleTitle.SingleAtomModule"), iClock, Photon.DEFAULT_SPEED * LasersApplication.ONE_ATOM_MODULE_SPEED);
        this.init();
    }

    public void reset() {
        super.reset();
        this.deactivate();
        this.setThreeEnergyLevels(false);
        this.laserControlPanel = new UniversalLaserControlPanel(this, true);
        this.setControlPanel(this.laserControlPanel);
        this.laserControlPanel.setUpperTransitionView(0);
        this.setPumpingPhotonView(0);
        this.laserControlPanel.setThreeEnergyLevels(false);
        this.setMirrorsEnabled(false);
        this.setDisplayHighLevelEmissions(false);
        this.activate();
        TwoLevelElementProperties twoLevelElementProperties = new TwoLevelElementProperties();
        AtomicState[] atomicStateArray = this.atom.getStates();
        for (int i = 0; i < atomicStateArray.length; ++i) {
            AtomicState atomicState = atomicStateArray[i];
            atomicState.setEnergyLevel(twoLevelElementProperties.getStates()[i].getEnergyLevel());
            atomicState.setEnergyLevel(twoLevelElementProperties.getStates()[i].getEnergyLevel());
        }
    }

    private void init() {
        Point2D.Double double_ = new Point2D.Double(this.getCavity().getBounds().getX() - 100.0, this.getCavity().getBounds().getY() + this.getCavity().getBounds().getHeight() / 2.0);
        Beam beam = ((LaserModel)this.getModel()).getSeedBeam();
        beam.setPosition(double_);
        beam.setBeamWidth(0.5);
        beam.setDirection(new Vector2D(1.0, 0.0));
        beam.setFanout(LasersConfig.SEED_BEAM_FANOUT);
        beam.setPhotonsPerSecond(1.0);
        Beam beam2 = ((LaserModel)this.getModel()).getPumpingBeam();
        Point2D.Double double_2 = new Point2D.Double(this.getCavity().getBounds().getX() + this.getCavity().getBounds().getWidth() / 2.0, this.getCavity().getBounds().getY() - 100.0);
        beam2.setDirection(new Vector2D(0.0, 1.0));
        beam2.setPosition(double_2);
        beam2.setFanout(Math.toRadians(LasersConfig.SEED_BEAM_FANOUT * 2.0) * 1000.0);
        beam2.setBeamWidth(beam.getBeamWidth() * 100.0);
        beam2.setPhotonsPerSecond(0.0);
        beam2.setMaxPhotonsPerSecond((int)beam2.getMaxPhotonsPerSecond() / 2);
        beam.setEnabled(true);
        beam2.setEnabled(false);
        Rectangle2D.Double double_3 = new Rectangle2D.Double((int)beam.getPosition().getX() - 55, (int)(beam.getPosition().getY() + beam.getBeamWidth() / 2.0 - 25.0), 100.0, 50.0);
        BufferedImage bufferedImage = LasersResources.getImage("flashlight.png");
        double d = ((RectangularShape)double_3).getWidth() / (double)bufferedImage.getWidth();
        double d2 = ((RectangularShape)double_3).getHeight() / (double)bufferedImage.getHeight();
        AffineTransformOp affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance(d, d2), 2);
        BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        Object object = new AffineTransform();
        ((AffineTransform)object).translate(((RectangularShape)double_3).getX(), ((RectangularShape)double_3).getY());
        Object object2 = new LampGraphic(beam, this.getApparatusPanel(), bufferedImage2, (AffineTransform)object);
        this.addGraphic((PhetGraphic)object2, 14.0);
        object = new PhetImageGraphic((Component)this.getApparatusPanel(), LasersResources.getImage("wire.png"));
        ((PhetImageGraphic)object).setImage(BufferedImageUtils.getRotatedImage(((PhetImageGraphic)object).getImage(), -1.5707963267948966));
        ((PhetGraphic)object).setLocation(50, 250);
        this.getApparatusPanel().addGraphic((PhetGraphic)object);
        object2 = new Point((int)beam.getPosition().getX() + 40, (int)beam.getPosition().getY() + 70);
        this.seedBeamControl = new BeamControl(this.getApparatusPanel(), this, (Point)object2, beam, 380.0, 780.0, LasersResources.getImage("beam-control.png"));
        this.getApparatusPanel().addGraphic(this.seedBeamControl);
        object = new AffineTransform();
        ((AffineTransform)object).translate(this.getLaserOrigin().getX() + (double)bufferedImage2.getHeight() + 150.0 - (double)(bufferedImage2.getHeight() / 2), 10.0);
        ((AffineTransform)object).rotate(1.5707963267948966);
        object2 = new AffineTransformOp(new AffineTransform(), 2).filter(bufferedImage2, null);
        this.pumpingLampGraphic = new LampGraphic(beam2, this.getApparatusPanel(), (BufferedImage)object2, (AffineTransform)object);
        this.setPumpLampGraphic(this.pumpingLampGraphic);
        this.pumpingLampGraphic.setVisible(false);
        this.addGraphic(this.pumpingLampGraphic, 14.0);
        PhetImageGraphic phetImageGraphic = new PhetImageGraphic((Component)this.getApparatusPanel(), LasersResources.getImage("wire.png"));
        AffineTransform affineTransform = AffineTransform.getScaleInstance(0.6, 1.0);
        AffineTransformOp affineTransformOp2 = new AffineTransformOp(affineTransform, 2);
        phetImageGraphic.setImage(affineTransformOp2.filter(phetImageGraphic.getImage(), null));
        phetImageGraphic.setLocation((int)beam2.getPosition().getX(), (int)(beam2.getPosition().getY() - 20.0));
        Point point = new Point((int)(beam2.getPosition().getX() + 170.0), (int)(beam2.getPosition().getY() - 90.0));
        this.pumpBeamControl = new BeamControl(this.getApparatusPanel(), this, point, beam2, 380.0, 780.0, LasersResources.getImage("beam-control.png"));
        phetImageGraphic.setLocation(-170, 40);
        this.pumpBeamControl.addGraphic(phetImageGraphic);
        this.getApparatusPanel().addGraphic(this.pumpBeamControl);
        this.setEnergyLevelsAveragingPeriod(0.0);
        this.setThreeEnergyLevels(false);
        this.atom = new LaserAtom(this.getLaserModel(), (ElementProperties)new TwoLevelElementProperties());
        this.atom.setPosition(this.getLaserOrigin().getX() + 150.0, this.getLaserOrigin().getY() + 60.0);
        this.atom.setVelocity(0.0, 0.0);
        this.addAtom(this.atom);
        this.laserControlPanel = new UniversalLaserControlPanel(this, true);
        this.setControlPanel(this.laserControlPanel);
        this.laserControlPanel.setUpperTransitionView(0);
        this.setPumpingPhotonView(0);
    }

    public void activate() {
        super.activate();
        this.laserControlPanel.setThreeEnergyLevels(this.getThreeEnergyLevels());
    }

    public void setThreeEnergyLevels(boolean bl) {
        super.setThreeEnergyLevels(bl);
        if (this.pumpingLampGraphic != null) {
            this.pumpingLampGraphic.setVisible(bl);
            this.pumpBeamControl.setVisible(bl);
            this.getLaserModel().getPumpingBeam().setEnabled(bl);
        }
        if (this.getBeamCurtainGraphic() != null) {
            this.getBeamCurtainGraphic().setVisible(bl);
        }
    }
}

