/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.controller.module;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetgraphics.application.PhetGraphicsModule;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.common.phetgraphics.view.help.HelpManager;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.Beam;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.common.quantum.model.PhotonEmissionListener;
import edu.colorado.phet.common.quantum.model.PhotonEmittedEvent;
import edu.colorado.phet.common.quantum.model.StimulatedPhoton;
import edu.colorado.phet.common.quantum.model.Tube;
import edu.colorado.phet.lasers.LasersConfig;
import edu.colorado.phet.lasers.ShowActualButton;
import edu.colorado.phet.lasers.controller.Kaboom;
import edu.colorado.phet.lasers.controller.RightMirrorReflectivityControlPanel;
import edu.colorado.phet.lasers.help.EnergyLevelPanelHelp;
import edu.colorado.phet.lasers.model.LaserModel;
import edu.colorado.phet.lasers.model.mirror.BandPass;
import edu.colorado.phet.lasers.model.mirror.LeftReflecting;
import edu.colorado.phet.lasers.model.mirror.PartialMirror;
import edu.colorado.phet.lasers.model.mirror.RightReflecting;
import edu.colorado.phet.lasers.view.AnnotatedAtomGraphic;
import edu.colorado.phet.lasers.view.AtomGraphic;
import edu.colorado.phet.lasers.view.BeamCurtainGraphic;
import edu.colorado.phet.lasers.view.LampGraphic;
import edu.colorado.phet.lasers.view.LaserCurtainGraphic;
import edu.colorado.phet.lasers.view.LaserEnergyLevelMonitorPanel;
import edu.colorado.phet.lasers.view.LaserWaveGraphic;
import edu.colorado.phet.lasers.view.MatchState;
import edu.colorado.phet.lasers.view.MirrorGraphic;
import edu.colorado.phet.lasers.view.PhotonGraphic;
import edu.colorado.phet.lasers.view.TubeGraphic;
import edu.colorado.phet.lasers.view.monitors.PowerMeterGraphic;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class BaseLaserModule
extends PhetGraphicsModule {
    protected static final Point2D s_origin = LasersConfig.ORIGIN;
    private Tube cavity;
    private Point2D laserOrigin;
    private LaserModel laserModel;
    private PartialMirror rightMirror;
    private PartialMirror leftMirror;
    private MirrorGraphic rightMirrorGraphic;
    private MirrorGraphic leftMirrorGraphic;
    private LaserEnergyLevelMonitorPanel laserEnergyLevelsMonitorPanel;
    private Beam seedBeam;
    private Beam pumpingBeam;
    private JPanel reflectivityControlPanel;
    private int pumpingPhotonView;
    private int lasingPhotonView = 0;
    private BeamCurtainGraphic beamCurtainGraphic;
    private LaserWaveGraphic waveGraphic;
    private LampGraphic pumpLampGraphic;
    private int numPhotons;
    private boolean displayHighLevelEmissions;
    private boolean threeEnergyLevels;
    private boolean mirrorsEnabled;
    private double middleStateMeanLifetime = 400.0;
    private double highStateMeanLifetime = 100.0;
    private HelpManager energyLevelsPanelHelpManager;
    private Kaboom kaboom;
    private PhetFrame frame;
    private double photonSpeed;

    public BaseLaserModule(PhetFrame phetFrame, String string, IClock iClock, double d) {
        super(string, iClock);
        this.frame = phetFrame;
        this.photonSpeed = d;
        this.laserModel = new LaserModel(d);
        this.setModel(this.laserModel);
        this.laserModel.setBounds(new Rectangle2D.Double(0.0, 0.0, 800.0, 600.0));
        ApparatusPanel2 apparatusPanel2 = new ApparatusPanel2(this.getClock());
        apparatusPanel2.setUseOffscreenBuffer(true);
        this.setApparatusPanel(apparatusPanel2);
        apparatusPanel2.setBackground(Color.white);
        this.createCavity();
        this.createBeams();
        this.createEnergyLevelsDialog(this.getClock(), null);
        this.createMirrors();
        PowerMeterGraphic powerMeterGraphic = new PowerMeterGraphic(PhetApplication.getInstance().getPhetFrame(), this.getLaserModel(), this.rightMirror);
        powerMeterGraphic.setLocation(new Point(175, 360));
        this.getApparatusPanel().addGraphic(powerMeterGraphic, Double.MAX_VALUE);
        powerMeterGraphic.setVisible(true);
        this.kaboom = new Kaboom(this);
        this.getModel().addModelElement(this.kaboom);
        this.createHelp();
    }

    protected JComponent createClockControlPanel(IClock iClock) {
        JComponent jComponent = super.createClockControlPanel(iClock);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jComponent, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(new ShowActualButton());
        jPanel.add((Component)jPanel2, "West");
        return jPanel;
    }

    public double getPhotonSpeed() {
        return this.photonSpeed;
    }

    public void activate() {
        super.activate();
        StimulatedPhoton.setStimulationBounds(this.cavity.getBounds());
        this.laserEnergyLevelsMonitorPanel.relayout();
        this.getLaserModel().getMiddleEnergyState().setMeanLifetime(this.middleStateMeanLifetime);
        this.getLaserModel().getHighEnergyState().setMeanLifetime(this.highStateMeanLifetime);
    }

    public void deactivate() {
        super.deactivate();
        this.middleStateMeanLifetime = this.getLaserModel().getMiddleEnergyState().getMeanLifeTime();
        this.highStateMeanLifetime = this.getLaserModel().getHighEnergyState().getMeanLifeTime();
    }

    protected void createEnergyLevelsDialog(IClock iClock, PhetFrame phetFrame) {
        this.laserEnergyLevelsMonitorPanel = new LaserEnergyLevelMonitorPanel(this, iClock);
    }

    private void createCavity() {
        this.laserOrigin = new Point2D.Double(s_origin.getX() + 50.0, s_origin.getY());
        this.cavity = new Tube(this.laserOrigin, 300.0, 120.0);
        this.getModel().addModelElement(this.cavity);
        TubeGraphic tubeGraphic = new TubeGraphic(this.getApparatusPanel(), this.cavity);
        this.addGraphic(tubeGraphic, 10.0);
    }

    private void createBeams() {
        this.seedBeam = new Beam(Photon.RED, s_origin, 400.0, 120.0 - Photon.RADIUS, new Vector2D(1.0, 0.0), 30.0, LasersConfig.SEED_BEAM_FANOUT, this.getPhotonSpeed());
        this.seedBeam.addPhotonEmittedListener(new InternalPhotonEmittedListener());
        this.seedBeam.setEnabled(true);
        this.getLaserModel().setStimulatingBeam(this.seedBeam);
        this.pumpingBeam = new Beam(Photon.BLUE, new Point2D.Double(s_origin.getX() + 50.0, s_origin.getY() - 50.0), 1000.0, this.cavity.getWidth(), new Vector2D(0.0, 1.0), 30.0, LasersConfig.PUMPING_BEAM_FANOUT, this.getPhotonSpeed());
        this.pumpingBeam.addPhotonEmittedListener(new InternalPhotonEmittedListener());
        this.pumpingBeam.setEnabled(true);
        this.getLaserModel().setPumpingBeam(this.pumpingBeam);
    }

    protected void createMirrors() {
        if (this.rightMirror != null) {
            this.getModel().removeModelElement(this.rightMirror);
        }
        if (this.leftMirror != null) {
            this.getModel().removeModelElement(this.leftMirror);
        }
        Point2D.Double double_ = new Point2D.Double(this.cavity.getPosition().getX() + this.cavity.getWidth(), this.cavity.getPosition().getY());
        Point2D.Double double_2 = new Point2D.Double(this.cavity.getPosition().getX() + this.cavity.getWidth(), this.cavity.getPosition().getY() + this.cavity.getHeight());
        this.rightMirror = new PartialMirror(double_, double_2);
        BandPass bandPass = new BandPass(380.0, 780.0);
        this.rightMirror.addReflectionStrategy(bandPass);
        this.rightMirror.addReflectionStrategy(new LeftReflecting());
        this.rightMirrorGraphic = new MirrorGraphic(this.getApparatusPanel(), this.rightMirror, 1);
        Point2D.Double double_3 = new Point2D.Double(this.cavity.getPosition().getX(), this.cavity.getPosition().getY());
        Point2D.Double double_4 = new Point2D.Double(this.cavity.getPosition().getX(), this.cavity.getPosition().getY() + this.cavity.getHeight());
        this.leftMirror = new PartialMirror(double_3, double_4);
        this.leftMirror.addReflectionStrategy(bandPass);
        this.leftMirror.addReflectionStrategy(new RightReflecting());
        this.leftMirror.setReflectivity(1.0);
        this.leftMirrorGraphic = new MirrorGraphic(this.getApparatusPanel(), this.leftMirror, 2);
        RightMirrorReflectivityControlPanel rightMirrorReflectivityControlPanel = new RightMirrorReflectivityControlPanel(this.rightMirror);
        this.reflectivityControlPanel = new JPanel();
        Dimension dimension = rightMirrorReflectivityControlPanel.getPreferredSize();
        this.reflectivityControlPanel.setBounds((int)this.rightMirror.getPosition().getX() + 10, (int)(this.rightMirror.getPosition().getY() + this.rightMirror.getBounds().getHeight()), (int)dimension.getWidth() + 10, (int)dimension.getHeight() + 10);
        this.reflectivityControlPanel.add(rightMirrorReflectivityControlPanel);
        rightMirrorReflectivityControlPanel.setBorder(new BevelBorder(0));
        this.reflectivityControlPanel.setOpaque(false);
        this.reflectivityControlPanel.setVisible(false);
        this.getApparatusPanel().add(this.reflectivityControlPanel);
        this.addLasingGraphics();
    }

    private void addLasingGraphics() {
        double d = 0.7;
        Rectangle rectangle = new Rectangle((int)this.cavity.getBounds().getX(), (int)this.cavity.getBounds().getY(), (int)this.cavity.getBounds().getWidth(), (int)this.cavity.getBounds().getHeight());
        Ellipse2D.Double double_ = new Ellipse2D.Double(rectangle.getMaxX() - 7.5, rectangle.getMinY(), 15.0, this.cavity.getBounds().getHeight());
        Area area = new Area(rectangle);
        area.add(new Area(double_));
        LaserCurtainGraphic laserCurtainGraphic = new LaserCurtainGraphic((Component)this.getApparatusPanel(), (Shape)area, this.laserModel, new AtomicState[]{this.getLaserModel().getGroundState(), this.getLaserModel().getMiddleEnergyState()}, d);
        this.laserModel.addLaserListener(laserCurtainGraphic);
        this.addGraphic(laserCurtainGraphic, 13.0);
        Rectangle rectangle2 = new Rectangle((int)this.cavity.getBounds().getMaxX(), (int)this.cavity.getBounds().getY(), 500, (int)this.cavity.getBounds().getHeight());
        final LaserCurtainGraphic laserCurtainGraphic2 = new LaserCurtainGraphic((Component)this.getApparatusPanel(), (Shape)rectangle2, this.laserModel, new AtomicState[]{this.getLaserModel().getGroundState(), this.getLaserModel().getMiddleEnergyState()}, 0.7);
        this.laserModel.addLaserListener(laserCurtainGraphic2);
        this.addGraphic(laserCurtainGraphic2, 10.0);
        this.rightMirror.addListener(new PartialMirror.Listener(){

            public void reflectivityChanged(PartialMirror.ReflectivityChangedEvent reflectivityChangedEvent) {
                laserCurtainGraphic2.setMaxAlpha(1.0 - Math.pow(reflectivityChangedEvent.getReflectivity(), 1.5));
            }
        });
    }

    public boolean hasHelp() {
        return true;
    }

    private void createHelp() {
        this.energyLevelsPanelHelpManager = new HelpManager(this.getEnergyLevelsMonitorPanel());
        new EnergyLevelPanelHelp(this.energyLevelsPanelHelpManager);
    }

    public void setHelpEnabled(boolean bl) {
        super.setHelpEnabled(bl);
        this.energyLevelsPanelHelpManager.setHelpEnabled(this.getEnergyLevelsMonitorPanel(), bl);
    }

    public void setLasingPhotonView(int n) {
        this.lasingPhotonView = n;
        switch (n) {
            case 0: {
                if (this.waveGraphic == null) break;
                this.waveGraphic.setVisible(false);
                break;
            }
            case 1: {
                AtomicState[] atomicStateArray = new AtomicState[]{this.getLaserModel().getGroundState(), this.getLaserModel().getMiddleEnergyState()};
                if (this.waveGraphic == null) {
                    this.waveGraphic = new LaserWaveGraphic(this.getApparatusPanel(), this.getCavity(), this.rightMirror, this, atomicStateArray);
                }
                this.waveGraphic.setVisible(true);
                break;
            }
            default: {
                throw new RuntimeException("Invalid parameter value");
            }
        }
    }

    public void setPumpingPhotonView(int n) {
        this.pumpingPhotonView = n;
        switch (n) {
            case 0: {
                this.getApparatusPanel().removeGraphic(this.beamCurtainGraphic);
                PhotonGraphic.setAllVisible(true, this.getPumpingBeam().getWavelength());
                break;
            }
            case 2: {
                if (this.beamCurtainGraphic == null) {
                    this.beamCurtainGraphic = new BeamCurtainGraphic(this.getApparatusPanel(), this.pumpingBeam);
                }
                this.addGraphic(this.beamCurtainGraphic, 1.0);
                PhotonGraphic.setAllVisible(false, this.getPumpingBeam().getWavelength());
                break;
            }
            default: {
                throw new RuntimeException("Invalid parameter value");
            }
        }
    }

    protected Point2D getLaserOrigin() {
        return this.laserOrigin;
    }

    public Tube getCavity() {
        return this.cavity;
    }

    public LaserModel getLaserModel() {
        return (LaserModel)this.getModel();
    }

    public PartialMirror getRightMirror() {
        return this.rightMirror;
    }

    public boolean isMirrorsEnabled() {
        return this.mirrorsEnabled;
    }

    public Beam getPumpingBeam() {
        return this.pumpingBeam;
    }

    protected PhetGraphic getBeamCurtainGraphic() {
        return this.beamCurtainGraphic;
    }

    public LaserEnergyLevelMonitorPanel getEnergyLevelsMonitorPanel() {
        return this.laserEnergyLevelsMonitorPanel;
    }

    public void setEnergyLevelsAveragingPeriod(double d) {
        this.laserEnergyLevelsMonitorPanel.setAveragingPeriod((long)d);
    }

    public void setDisplayHighLevelEmissions(boolean bl) {
        this.displayHighLevelEmissions = bl;
    }

    public boolean getThreeEnergyLevels() {
        return this.threeEnergyLevels;
    }

    public void setThreeEnergyLevels(boolean bl) {
        int n = bl ? 3 : 2;
        this.laserModel.setNumEnergyLevels(n);
        this.threeEnergyLevels = bl;
        this.getEnergyLevelsMonitorPanel().setNumLevels(n);
    }

    public void setMirrorsEnabled(boolean bl) {
        this.mirrorsEnabled = bl;
        this.getModel().removeModelElement(this.leftMirror);
        this.getModel().removeModelElement(this.rightMirror);
        this.getApparatusPanel().removeGraphic(this.leftMirrorGraphic);
        this.getApparatusPanel().removeGraphic(this.rightMirrorGraphic);
        this.reflectivityControlPanel.setVisible(bl);
        if (bl) {
            this.getModel().addModelElement(this.leftMirror);
            this.getModel().addModelElement(this.rightMirror);
            this.getApparatusPanel().addGraphic(this.leftMirrorGraphic, 14.0);
            this.getApparatusPanel().addGraphic(this.rightMirrorGraphic, 11.0);
            this.getApparatusPanel().revalidate();
        }
        this.seedBeam.setEnabled(!bl);
        this.getApparatusPanel().paintImmediately(this.getApparatusPanel().getBounds());
    }

    protected void setPumpLampGraphic(LampGraphic lampGraphic) {
        this.pumpLampGraphic = lampGraphic;
    }

    protected AtomGraphic addAtom(Atom atom) {
        this.getModel().addModelElement(atom);
        AnnotatedAtomGraphic annotatedAtomGraphic = new AnnotatedAtomGraphic(this.getApparatusPanel(), atom);
        this.addGraphic(annotatedAtomGraphic, 12.0);
        atom.addPhotonEmittedListener(new InternalPhotonEmittedListener());
        atom.addLeftSystemListener(new AtomRemovalListener(annotatedAtomGraphic));
        return annotatedAtomGraphic;
    }

    public LampGraphic getPumpLampGraphic() {
        return this.pumpLampGraphic;
    }

    public void reset() {
        this.laserModel.reset();
        if (this.rightMirror != null) {
            this.rightMirror.setReflectivity(1.0);
        }
        this.seedBeam.setWavelength(Photon.RED);
        this.pumpingBeam.setWavelength(Photon.BLUE);
        this.setPumpingPhotonView(2);
        this.laserEnergyLevelsMonitorPanel.reset();
        this.getModel().removeModelElement(this.kaboom);
        this.kaboom.reset();
        this.kaboom = new Kaboom(this);
        this.getModel().addModelElement(this.kaboom);
        this.laserModel.setModelPaused(false);
    }

    public MatchState getMatch(Beam beam) {
        return this.getLaserModel().getMatch(beam);
    }

    public void setBackgroundColor(Color color) {
        this.getApparatusPanel().setBackground(color);
    }

    public Color getBackgroundColor() {
        return this.getApparatusPanel().getBackground();
    }

    public class AtomRemovalListener
    implements Atom.LeftSystemListener {
        private AtomGraphic atomGraphic;

        public AtomRemovalListener(AtomGraphic atomGraphic) {
            this.atomGraphic = atomGraphic;
        }
    }

    public class InternalPhotonEmittedListener
    implements PhotonEmissionListener {
        public void photonEmitted(PhotonEmittedEvent photonEmittedEvent) {
            Object object;
            BaseLaserModule.this.numPhotons++;
            Photon photon = photonEmittedEvent.getPhoton();
            BaseLaserModule.this.getModel().addModelElement(photon);
            boolean bl = true;
            Object object2 = photonEmittedEvent.getSource();
            if (object2 instanceof Atom) {
                object = (Atom)object2;
                if (((Atom)object).getStates().length > 2 && ((Atom)object).getCurrState() == ((Atom)object).getStates()[2] && !BaseLaserModule.this.displayHighLevelEmissions) {
                    bl = false;
                } else {
                    double d = BaseLaserModule.this.laserModel.getMiddleEnergyState().getEnergyLevel() - BaseLaserModule.this.laserModel.getGroundState().getEnergyLevel();
                    if (Math.abs(photon.getEnergy() - d) <= 0.05) {
                        boolean bl2 = bl = BaseLaserModule.this.lasingPhotonView == 0;
                    }
                }
            }
            if (object2 == BaseLaserModule.this.seedBeam) {
                bl = true;
            }
            if (object2 == BaseLaserModule.this.pumpingBeam) {
                bl = BaseLaserModule.this.pumpingPhotonView == 0;
            }
            object = PhotonGraphic.getInstance(BaseLaserModule.this.getApparatusPanel(), photon);
            ((PhetGraphic)object).setVisible(bl);
            BaseLaserModule.this.addGraphic((PhetGraphic)object, 13.0);
            photon.addLeftSystemListener(new PhotonLeftSystemListener(photon, (PhotonGraphic)object));
        }
    }

    public class PhotonLeftSystemListener
    implements Photon.LeftSystemEventListener {
        private PhotonGraphic graphic;

        public PhotonLeftSystemListener(Photon photon, PhotonGraphic photonGraphic) {
            this.graphic = photonGraphic;
        }

        public void leftSystemEventOccurred(Photon.LeftSystemEvent leftSystemEvent) {
            BaseLaserModule.this.numPhotons--;
            BaseLaserModule.this.getApparatusPanel().removeGraphic(this.graphic);
            BaseLaserModule.this.getApparatusPanel().repaint(this.graphic.getBounds());
            this.graphic = null;
        }
    }
}

