/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.controller;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.lasers.LasersResources;
import edu.colorado.phet.lasers.model.mirror.PartialMirror;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RightMirrorReflectivityControlPanel
extends JPanel
implements SimpleObserver {
    private JSlider reflectivitySlider;
    private JTextField reflectivityTF;
    private PartialMirror mirror;

    public RightMirrorReflectivityControlPanel(final PartialMirror partialMirror) {
        this.mirror = partialMirror;
        partialMirror.addObserver(this);
        this.reflectivityTF = new JTextField(4);
        this.reflectivityTF.setEditable(false);
        this.reflectivityTF.setHorizontalAlignment(4);
        Font font = this.reflectivityTF.getFont();
        this.reflectivityTF.setFont(new Font(font.getName(), 1, 12));
        this.reflectivityTF.setText(Double.toString(10.0));
        this.reflectivitySlider = new JSlider(1, 0, 100, 50);
        this.reflectivitySlider.setPreferredSize(new Dimension(40, 100));
        this.reflectivitySlider.setPaintTicks(true);
        this.reflectivitySlider.setMajorTickSpacing(10);
        this.reflectivitySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                partialMirror.setReflectivity((double)RightMirrorReflectivityControlPanel.this.reflectivitySlider.getValue() / 100.0);
                RightMirrorReflectivityControlPanel.this.reflectivityTF.setText(Double.toString(RightMirrorReflectivityControlPanel.this.reflectivitySlider.getValue()));
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(LasersResources.getString("RightMirrorReflectivityControlPanel.BorderTitle"));
        gridBagConstraints.gridwidth = 2;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.reflectivitySlider, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.reflectivityTF, gridBagConstraints);
    }

    public void update() {
        int n = (int)(this.mirror.getReflectivity() * 100.0);
        if (this.reflectivitySlider.getValue() != n) {
            this.reflectivityTF.setText(Integer.toString(n));
            this.reflectivitySlider.setValue(n);
        }
    }
}

