/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.quantum.model;

import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.Photon;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class StimulatedPhoton
extends Photon {
    private static Rectangle2D stimulationBounds;
    private static double SEPARATION;

    public static void setStimulationBounds(Rectangle2D rectangle2D) {
        stimulationBounds = rectangle2D;
    }

    public static Photon createStimulated(Photon photon, Point2D point2D, Atom atom) {
        Photon photon2 = new Photon(photon.getWavelength(), point2D, photon.getVelocity());
        int n = 1;
        double d = SEPARATION;
        int n2 = n % 2 == 0 ? 1 : -1;
        double d2 = d * (double)n2 * (photon.getVelocity().getX() / photon.getVelocity().getMagnitude());
        double d3 = d * (double)(-n2) * (photon.getVelocity().getY() / photon.getVelocity().getMagnitude());
        double d4 = photon.getPosition().getY() + d2;
        double d5 = photon.getPosition().getX() + d3;
        double d6 = stimulationBounds.getMinY() + Photon.RADIUS;
        double d7 = stimulationBounds.getMaxY();
        if (d4 < d6 || d4 > d7) {
            d4 = atom.getPosition().getY();
            d5 = atom.getPosition().getX() - Photon.RADIUS;
        }
        photon2.setPosition(d5, d4);
        return photon2;
    }

    public static double getSeparation() {
        return SEPARATION;
    }

    public static void setSeparation(double d) {
        SEPARATION = d;
    }

    static {
        SEPARATION = 9.0;
    }
}

