/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.quantum.model;

import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.EnergyEmissionStrategy;
import edu.colorado.phet.common.quantum.model.GroundState;
import java.util.Arrays;

public class ElementProperties {
    private double[] energyLevels;
    private String name;
    private AtomicState[] states;
    private EnergyEmissionStrategy energyEmissionStrategy;
    private double meanStateLifetime;

    protected ElementProperties(String string, double[] dArray, EnergyEmissionStrategy energyEmissionStrategy, double d) {
        this.name = string;
        this.energyLevels = dArray;
        this.energyEmissionStrategy = energyEmissionStrategy;
        this.meanStateLifetime = d;
        this.initStates();
        this.setEnergyLevels(dArray);
    }

    protected void setEnergyLevels(double[] dArray) {
        if (dArray.length != this.states.length) {
            this.energyLevels = dArray;
            this.initStates();
        } else {
            this.energyLevels = dArray;
            this.updateStates();
        }
    }

    public AtomicState getGroundState() {
        return this.getStates()[0];
    }

    public double getMeanStateLifetime() {
        return this.meanStateLifetime;
    }

    public EnergyEmissionStrategy getEnergyEmissionStrategy() {
        return this.energyEmissionStrategy;
    }

    public AtomicState[] getStates() {
        return this.states;
    }

    public String toString() {
        return this.name;
    }

    private void initStates() {
        this.states = new AtomicState[this.energyLevels.length];
        this.states[0] = new GroundState();
        this.states[0].setEnergyLevel(this.energyLevels[0]);
        for (int i = 1; i < this.states.length; ++i) {
            this.states[i] = new AtomicState();
            this.states[i].setEnergyLevel(0.0);
        }
        AtomicState.linkStates(this.states);
        this.updateStates();
    }

    private void updateStates() {
        int n;
        double[] dArray = new double[this.energyLevels.length];
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = this.energyLevels[n];
        }
        Arrays.sort(dArray);
        this.states[0].setEnergyLevel(dArray[0]);
        for (n = 1; n < this.states.length; ++n) {
            double d = dArray[n];
            this.states[n].setEnergyLevel(d);
            this.meanStateLifetime = this.getMeanStateLifetime();
            this.states[n].setMeanLifetime(this.meanStateLifetime);
        }
    }
}

