/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.quantum.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.Particle;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.common.quantum.model.PhotonEmissionListener;
import edu.colorado.phet.common.quantum.model.PhotonEmittedEvent;
import edu.colorado.phet.common.quantum.model.PhotonSource;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Random;

public class Beam
extends Particle
implements PhotonSource {
    private static Random gaussianGenerator = new Random();
    private static Random startPositionGenerator = new Random();
    private double nextTimeToProducePhoton = 0.0;
    private double wavelength;
    private Vector2D velocity;
    private double timeSinceLastPhotonProduced = 0.0;
    private double photonsPerSecond;
    private double maxPhotonsPerSecond;
    private boolean isEnabled;
    private double fanout = 0.0;
    private boolean isPhotonProductionGaussian = false;
    private double length;
    private double beamWidth;
    private double speed;
    private EventChannel rateChangeEventChannel = new EventChannel(PhotonSource.RateChangeListener.class);
    private PhotonSource.RateChangeListener rateChangeListenerProxy = (PhotonSource.RateChangeListener)this.rateChangeEventChannel.getListenerProxy();
    private EventChannel wavelengthChangeEventChannel = new EventChannel(PhotonSource.WavelengthChangeListener.class);
    private PhotonSource.WavelengthChangeListener wavelengthChangeListenerProxy = (PhotonSource.WavelengthChangeListener)this.wavelengthChangeEventChannel.getListenerProxy();
    private EventChannel photonEmittedEventChannel = new EventChannel(PhotonEmissionListener.class);
    private PhotonEmissionListener photonEmittedListenerProxy = (PhotonEmissionListener)this.photonEmittedEventChannel.getListenerProxy();

    public Beam(double d, Point2D point2D, double d2, double d3, Vector2D vector2D, double d4, double d5, double d6) {
        this.speed = d6;
        this.fanout = d5;
        this.wavelength = d;
        this.maxPhotonsPerSecond = d4;
        this.setPosition(point2D);
        this.velocity = new Vector2D(vector2D).normalize().scale(d6);
        this.length = d2;
        this.beamWidth = d3;
    }

    public double getFanout() {
        return this.fanout;
    }

    public void setFanout(double d) {
        this.fanout = d;
    }

    public Shape getBounds() {
        double d = this.getFanout() / 2.0;
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        doubleGeneralPath.moveTo(this.getPosition());
        doubleGeneralPath.lineToRelative(0.0, -this.getBeamWidth() / 2.0);
        doubleGeneralPath.lineToRelative(this.getLength() * Math.cos(d), -this.getLength() * Math.sin(d) / 2.0);
        doubleGeneralPath.lineToRelative(0.0, this.getBeamWidth() + this.getLength() * Math.sin(d));
        doubleGeneralPath.lineToRelative(-this.getLength() * Math.cos(d), -this.getLength() * Math.sin(d) / 2.0);
        doubleGeneralPath.lineTo(this.getPosition());
        AffineTransform affineTransform = AffineTransform.getRotateInstance(this.getDirection(), this.getPosition().getX(), this.getPosition().getY());
        return doubleGeneralPath.getGeneralPath().createTransformedShape(affineTransform);
    }

    public void setDirection(Vector2D vector2D) {
        this.velocity = new Vector2D(vector2D).normalize().scale(this.speed);
    }

    public double getDirection() {
        return this.velocity.getAngle();
    }

    public void setBeamWidth(double d) {
        this.beamWidth = d;
    }

    public double getBeamWidth() {
        return this.beamWidth;
    }

    public double getLength() {
        return this.length;
    }

    public double getPhotonsPerSecond() {
        return this.photonsPerSecond;
    }

    public void setPhotonsPerSecond(double d) {
        if (this.photonsPerSecond == 0.0) {
            this.timeSinceLastPhotonProduced = 0.0;
        }
        this.photonsPerSecond = d;
        this.nextTimeToProducePhoton = this.getNextTimeToProducePhoton();
        this.rateChangeListenerProxy.rateChangeOccurred(new PhotonSource.RateChangeEvent(this));
    }

    public double getMaxPhotonsPerSecond() {
        return this.maxPhotonsPerSecond;
    }

    public void setMaxPhotonsPerSecond(int n) {
        this.maxPhotonsPerSecond = n;
    }

    public void setWavelength(double d) {
        this.wavelength = d;
        this.wavelengthChangeListenerProxy.wavelengthChanged(new PhotonSource.WavelengthChangeEvent(this));
    }

    public double getWavelength() {
        return this.wavelength;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
        this.timeSinceLastPhotonProduced = 0.0;
    }

    private Point2D genPosition() {
        double d = startPositionGenerator.nextDouble();
        double d2 = 10.0;
        double d3 = d * ((this.getBeamWidth() - d2) / 2.0) * (double)(startPositionGenerator.nextBoolean() ? 1 : -1);
        double d4 = d3 * Math.sin(this.getDirection());
        double d5 = -d3 * Math.cos(this.getDirection());
        return new Point2D.Double(this.getPosition().getX() + d4, this.getPosition().getY() + d5);
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        if (this.isEnabled()) {
            this.timeSinceLastPhotonProduced += d;
            if (this.nextTimeToProducePhoton < this.timeSinceLastPhotonProduced) {
                int n = (int)(this.timeSinceLastPhotonProduced * this.getPhotonsPerSecond() / 1000.0);
                for (int i = 0; i < n; ++i) {
                    Point2D point2D = this.genPosition();
                    double d2 = point2D.distance(this.getPosition()) / this.getBeamWidth() / 2.0 * this.getFanout();
                    double d3 = this.getDirection() - Math.atan2(point2D.getY() - this.getPosition().getY(), point2D.getX() - this.getPosition().getX());
                    if (d3 > 0.0) {
                        d2 *= -1.0;
                    }
                    Vector2D vector2D = new Vector2D(this.velocity).rotate(d2);
                    Photon photon = new Photon(this.getWavelength(), point2D, vector2D);
                    this.photonEmittedListenerProxy.photonEmitted(new PhotonEmittedEvent(this, photon));
                }
                this.nextTimeToProducePhoton = this.getNextTimeToProducePhoton();
                this.timeSinceLastPhotonProduced = 0.0;
            }
        }
    }

    private double getNextTimeToProducePhoton() {
        double d = this.isPhotonProductionGaussian ? gaussianGenerator.nextGaussian() + 1.0 : 1.0;
        return d / (this.photonsPerSecond / 1000.0);
    }

    public void addRateChangeListener(PhotonSource.RateChangeListener rateChangeListener) {
        this.rateChangeEventChannel.addListener(rateChangeListener);
    }

    public void addWavelengthChangeListener(PhotonSource.WavelengthChangeListener wavelengthChangeListener) {
        this.wavelengthChangeEventChannel.addListener(wavelengthChangeListener);
    }

    public void addPhotonEmittedListener(PhotonEmissionListener photonEmissionListener) {
        this.photonEmittedEventChannel.addListener(photonEmissionListener);
    }
}

