/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.quantum.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.common.quantum.QuantumConfig;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.common.quantum.model.StimulatedPhoton;
import java.awt.geom.Point2D;
import java.util.EventListener;
import java.util.EventObject;

public class AtomicState {
    public static final double minWavelength = Photon.BLUE - 20.0;
    public static final double maxWavelength = Photon.GRAY;
    public static final double minEnergy = PhysicsUtil.wavelengthToEnergy(maxWavelength);
    public static final double maxEnergy = PhysicsUtil.wavelengthToEnergy(minWavelength);
    protected static double STIMULATION_LIKELIHOOD = 0.2;
    private double energyLevel;
    private double meanLifetime = Double.POSITIVE_INFINITY;
    private AtomicState nextHigherState;
    private AtomicState nextLowerState;
    private EventChannel listenerChannel = new EventChannel(Listener.class);
    private Listener listenerProxy = (Listener)this.listenerChannel.getListenerProxy();

    public static void setStimulationLikelihood(double d) {
        STIMULATION_LIKELIHOOD = d;
    }

    public static double getStimulationLikelihood() {
        return STIMULATION_LIKELIHOOD;
    }

    public AtomicState() {
    }

    public AtomicState(AtomicState atomicState) {
        this.energyLevel = atomicState.getEnergyLevel();
        this.meanLifetime = atomicState.getMeanLifeTime();
        this.nextHigherState = atomicState.getNextHigherEnergyState();
        this.nextLowerState = atomicState.getNextLowerEnergyState();
    }

    public void enterState(Atom atom) {
    }

    public void leaveState(Atom atom) {
    }

    public double getEnergyLevel() {
        return this.energyLevel;
    }

    public double getMeanLifeTime() {
        return this.meanLifetime;
    }

    public void setMeanLifetime(double d) {
        this.meanLifetime = d;
        this.listenerProxy.meanLifetimeChanged(new Event(this));
    }

    public void setEnergyLevel(double d) {
        this.energyLevel = d;
        this.listenerProxy.energyLevelChanged(new Event(this));
    }

    public double getWavelength() {
        return PhysicsUtil.energyToWavelength(this.energyLevel);
    }

    public double determineEmittedPhotonWavelength(AtomicState atomicState) {
        double d = this.getEnergyLevel();
        double d2 = atomicState.getEnergyLevel();
        double d3 = Math.min(PhysicsUtil.energyToWavelength(d - d2), maxWavelength);
        return d3;
    }

    public double determineEmittedPhotonWavelength() {
        double d = PhysicsUtil.wavelengthToEnergy(this.getWavelength());
        double d2 = PhysicsUtil.wavelengthToEnergy(this.getNextLowerEnergyState().getWavelength());
        double d3 = Math.min(PhysicsUtil.energyToWavelength(d - d2), maxWavelength);
        return d3;
    }

    protected boolean isStimulatedBy(Photon photon, Atom atom) {
        boolean bl = false;
        AtomicState[] atomicStateArray = atom.getStates();
        if (QuantumConfig.ENABLE_ALL_STIMULATED_EMISSIONS) {
            for (int i = 0; i < atomicStateArray.length && atomicStateArray[i] != this && !bl; ++i) {
                AtomicState atomicState = atomicStateArray[i];
                if (!(atomicState.getEnergyLevel() < this.getEnergyLevel())) continue;
                double d = this.getEnergyLevel() - atomicState.getEnergyLevel();
                bl = Math.abs(photon.getEnergy() - d) <= 0.05 && Math.random() < STIMULATION_LIKELIHOOD;
            }
        } else {
            double d = this.getEnergyLevel() - this.getNextLowerEnergyState().getEnergyLevel();
            bl = Math.abs(photon.getEnergy() - d) <= 0.05 && Math.random() < STIMULATION_LIKELIHOOD;
        }
        return bl;
    }

    public void collideWithPhoton(Atom atom, Photon photon) {
        AtomicState atomicState = this.getElevatedState(atom, photon, this.getEnergyLevel());
        if (atomicState != null) {
            photon.removeFromSystem();
            atom.setCurrState(atomicState);
            return;
        }
        if (this.isStimulatedBy(photon, atom)) {
            Vector2D vector2D = new Vector2D(photon.getVelocity()).normalize();
            vector2D.scale(atom.getRadius());
            Point2D.Double double_ = new Point2D.Double(atom.getPosition().getX() + vector2D.getX(), atom.getPosition().getY() + vector2D.getY());
            photon.setPosition(double_);
            Photon photon2 = StimulatedPhoton.createStimulated(photon, double_, atom);
            atom.emitPhoton(photon2);
            atom.setCurrState(atom.getLowestEnergyState());
        }
    }

    public AtomicState getElevatedState(Atom atom, Photon photon, double d) {
        AtomicState atomicState = null;
        AtomicState[] atomicStateArray = atom.getStates();
        for (int i = atomicStateArray.length - 1; i >= 0 && atomicStateArray[i] != this && atomicState == null; --i) {
            double d2 = photon.getEnergy() - (atomicStateArray[i].getEnergyLevel() - d);
            if (!(Math.abs(d2) <= 0.05)) continue;
            atomicState = atomicStateArray[i];
        }
        return atomicState;
    }

    public AtomicState getNextLowerEnergyState() {
        return this.nextLowerState;
    }

    public void setNextLowerEnergyState(AtomicState atomicState) {
        this.nextLowerState = atomicState;
    }

    public AtomicState getNextHigherEnergyState() {
        return this.nextHigherState;
    }

    public void setNextHigherEnergyState(AtomicState atomicState) {
        this.nextHigherState = atomicState;
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.energyLevel) + Double.doubleToLongBits(this.meanLifetime));
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof AtomicState && object != null) {
            AtomicState atomicState = (AtomicState)object;
            bl = this.energyLevel == atomicState.energyLevel;
        }
        return bl;
    }

    public static void linkStates(AtomicState[] atomicStateArray) {
        for (int i = 1; i < atomicStateArray.length; ++i) {
            atomicStateArray[i].setNextLowerEnergyState(atomicStateArray[i - 1]);
            atomicStateArray[i - 1].setNextHigherEnergyState(atomicStateArray[i]);
        }
        atomicStateArray[atomicStateArray.length - 1].setNextHigherEnergyState(MaxEnergyState.instance());
    }

    public void addListener(Listener listener) {
        this.listenerChannel.addListener(listener);
    }

    public void removeListener(Listener listener) {
        this.listenerChannel.removeListener(listener);
    }

    public static class ChangeListenerAdapter
    implements Listener {
        public void energyLevelChanged(Event event) {
        }

        public void meanLifetimeChanged(Event event) {
        }
    }

    public static class Event
    extends EventObject {
        public Event(AtomicState atomicState) {
            super(atomicState);
        }

        public double getEnergy() {
            return ((AtomicState)this.getSource()).getEnergyLevel();
        }

        public AtomicState getAtomicState() {
            return (AtomicState)this.getSource();
        }

        public double getMeanLifetime() {
            return this.getAtomicState().getMeanLifeTime();
        }
    }

    public static interface Listener
    extends EventListener {
        public void energyLevelChanged(Event var1);

        public void meanLifetimeChanged(Event var1);
    }

    public static class MaxEnergyState
    extends AtomicState {
        private static MaxEnergyState instance = new MaxEnergyState();

        public static MaxEnergyState instance() {
            return instance;
        }

        private MaxEnergyState() {
            this.setEnergyLevel(this.getEnergyLevel());
        }

        public void collideWithPhoton(Atom atom, Photon photon) {
        }

        public AtomicState getNextLowerEnergyState() {
            return null;
        }

        public AtomicState getNextHigherEnergyState() {
            return null;
        }

        public double getWavelength() {
            return minWavelength - 80.0;
        }
    }

    public static class MinEnergyState
    extends AtomicState {
        private static MinEnergyState instance = new MinEnergyState();

        public static MinEnergyState instance() {
            return instance;
        }

        private MinEnergyState() {
            this.setEnergyLevel(minEnergy);
        }

        public void collideWithPhoton(Atom atom, Photon photon) {
        }

        public AtomicState getNextLowerEnergyState() {
            return null;
        }

        public AtomicState getNextHigherEnergyState() {
            return null;
        }
    }
}

