/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetgraphics.view.util;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class TransformManager {
    private JComponent component;
    private AffineTransform graphicTx = new AffineTransform();
    private AffineTransform mouseTx = new AffineTransform();
    private boolean referenceSizeSet;
    private Rectangle referenceBounds;
    private Dimension canvasSize = new Dimension();
    private double scale = 1.0;
    private Point2D viewPointOrigin = new Point2D.Double();

    public TransformManager(JComponent jComponent) {
        this.component = jComponent;
    }

    public void setReferenceSize() {
        this.referenceSizeSet = true;
        this.referenceBounds = this.component.getBounds();
    }

    public Rectangle getReferenceBounds() {
        return this.referenceBounds;
    }

    public AffineTransform getGraphicTx() {
        return this.graphicTx;
    }

    public Rectangle transform(Rectangle rectangle) {
        if (this.graphicTx != null) {
            Rectangle rectangle2 = this.graphicTx.createTransformedShape(rectangle).getBounds();
            return rectangle2;
        }
        return rectangle;
    }

    public boolean isReferenceSizeSet() {
        return this.referenceSizeSet;
    }

    public void setScale(double d) {
        this.graphicTx = AffineTransform.getScaleInstance(d, d);
        this.graphicTx.translate(this.viewPointOrigin.getX(), this.viewPointOrigin.getY());
        this.scale = d;
        try {
            this.mouseTx = this.graphicTx.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
    }

    public AffineTransform getMouseTx() {
        return this.mouseTx;
    }

    public boolean determineCanvasSize() {
        double d = this.referenceBounds.getHeight() / this.referenceBounds.getWidth();
        double d2 = (double)this.component.getHeight() / (double)this.component.getWidth();
        double d3 = 1.0;
        double d4 = 1.0;
        if (d2 < d) {
            d3 = d / d2;
        } else {
            d4 = d2 / d;
        }
        Dimension dimension = new Dimension(this.canvasSize);
        this.canvasSize.setSize(this.referenceBounds.getWidth() * d3, this.referenceBounds.getHeight() * d4);
        return dimension.width != this.canvasSize.width || dimension.height != this.canvasSize.height;
    }
}

