/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetgraphics.view;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphics2D;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsState;
import edu.colorado.phet.common.phetgraphics.view.util.TransformManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class ApparatusPanel2
extends ApparatusPanel
implements ClockListener {
    private TransformManager transformManager;
    private PaintStrategy paintStrategy;
    private ArrayList rectangles = new ArrayList();
    private Rectangle repaintArea;
    private ScaledComponentLayout scaledComponentLayout;
    private PanelResizeHandler panelResizeHandler;
    private MouseProcessor mouseProcessor;
    private IClock clock;
    static Random rand = new Random();
    private EventChannel changeEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeEventChannel.getListenerProxy();

    public ApparatusPanel2(IClock iClock) {
        super((Object)null);
        this.init(iClock);
    }

    protected void init(IClock iClock) {
        this.clock = iClock;
        iClock.addClockListener(this);
        this.mouseProcessor = new MouseProcessor(this.getGraphic(), iClock);
        this.addMouseListener(this.mouseProcessor);
        this.addMouseMotionListener(this.mouseProcessor);
        this.addKeyListener(this.getGraphic().getKeyAdapter());
        this.panelResizeHandler = new PanelResizeHandler();
        this.addComponentListener(this.panelResizeHandler);
        this.transformManager = new TransformManager(this);
        this.paintStrategy = new DefaultPaintStrategy(this);
        this.scaledComponentLayout = new ScaledComponentLayout(this);
    }

    public void handleUserInput() {
        this.mouseProcessor.handleUserInput();
    }

    private void saveLocation(Component component) {
        this.scaledComponentLayout.saveLocation(component);
    }

    public Component add(Component component) {
        this.saveLocation(component);
        return super.add(component);
    }

    public void add(Component component, Object object) {
        this.saveLocation(component);
        super.add(component, object);
    }

    public Component add(Component component, int n) {
        this.saveLocation(component);
        return super.add(component, n);
    }

    public Component add(String string, Component component) {
        this.saveLocation(component);
        return super.add(string, component);
    }

    public boolean isUseOffscreenBuffer() {
        return this.paintStrategy instanceof OffscreenBufferStrategy;
    }

    public void setUseOffscreenBuffer(boolean bl) {
        this.paintStrategy = bl ? new OffscreenBufferStrategy(this) : new DefaultPaintStrategy(this);
        this.setDoubleBuffered(!bl);
    }

    public void paint() {
        this.paintStrategy.paintImmediately();
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        this.repaint(n, n2, n3, n4);
    }

    public void repaint(Rectangle rectangle) {
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void repaint(int n, int n2, int n3, int n4) {
        this.addRectangleToRepaintList(n, n2, n3, n4);
    }

    public void repaint() {
        if (this.clock != null && this.clock.isPaused()) {
            super.repaint();
        }
    }

    private void paintDirtyRectanglesImmediately() {
        if (this.rectangles.size() > 0) {
            Rectangle rectangle = RectangleUtils.union(this.rectangles);
            this.repaintArea = this.transformManager.transform(rectangle);
            this.paintImmediately(this.repaintArea);
            this.rectangles.clear();
        }
    }

    private void addRectangleToRepaintList(int n, int n2, int n3, int n4) {
        if (n4 > 0 && n3 > 0) {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            this.rectangles.add(rectangle);
        }
    }

    public void repaint(long l) {
    }

    protected void paintComponent(Graphics graphics) {
        super.doPaintSuper(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D = new PhetGraphics2D(graphics2D);
        if (this.repaintArea == null) {
            this.repaintArea = this.getBounds();
        }
        graphics2D.setBackground(super.getBackground());
        Rectangle rectangle = graphics2D.getClipBounds();
        graphics2D.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.setup(graphics2D);
        GraphicsState graphicsState = new GraphicsState(graphics2D);
        this.paintStrategy.render(graphics2D, this.transformManager.getGraphicTx());
        graphicsState.restoreGraphics();
        super.drawBorder(graphics2D);
    }

    public void setReferenceSize() {
        this.transformManager.setReferenceSize();
        this.scaledComponentLayout.saveSwingComponentCoordinates(1.0);
        this.setScale(1.0);
        this.determineCanvasSize();
    }

    private void determineCanvasSize() {
        boolean bl = this.transformManager.determineCanvasSize();
        if (bl) {
            this.changeListenerProxy.canvasSizeChanged(new ChangeEvent(this));
            this.paint();
        }
    }

    public void setScale(double d) {
        this.transformManager.setScale(d);
        this.scaledComponentLayout.layoutSwingComponents(d);
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    public void clockTicked(ClockEvent clockEvent) {
        this.paint();
    }

    public void clockStarted(ClockEvent clockEvent) {
    }

    public void clockPaused(ClockEvent clockEvent) {
    }

    public void simulationTimeChanged(ClockEvent clockEvent) {
    }

    public void simulationTimeReset(ClockEvent clockEvent) {
    }

    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
    }

    public static class ChangeEvent
    extends EventObject {
        private ApparatusPanel2 apparatusPanel;

        public ChangeEvent(ApparatusPanel2 apparatusPanel2) {
            super(apparatusPanel2);
            this.apparatusPanel = apparatusPanel2;
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void canvasSizeChanged(ChangeEvent var1);
    }

    public static class DefaultPaintStrategy
    implements PaintStrategy {
        ApparatusPanel2 apparatusPanel2;

        public DefaultPaintStrategy(ApparatusPanel2 apparatusPanel2) {
            this.apparatusPanel2 = apparatusPanel2;
            this.componentResized();
        }

        public void paintImmediately() {
            this.apparatusPanel2.paintDirtyRectanglesImmediately();
        }

        public void render(Graphics2D graphics2D, AffineTransform affineTransform) {
            graphics2D.transform(affineTransform);
            this.apparatusPanel2.getGraphic().paint(graphics2D);
        }

        public void componentResized() {
        }
    }

    private class MouseProcessor
    implements MouseInputListener {
        private LinkedList mouseEventList;
        private IClock clock;
        private GraphicLayerSet handler;
        private Runnable pausedEventListProcessor = new Runnable(){

            public void run() {
                MouseProcessor.this.handleUserInput();
                ApparatusPanel2.this.paint();
            }
        };

        public MouseProcessor(GraphicLayerSet graphicLayerSet, IClock iClock) {
            this.clock = iClock;
            this.mouseEventList = new LinkedList();
            this.handler = graphicLayerSet;
        }

        public void handleUserInput() {
            this.processMouseEventList();
        }

        private void xformEventPt(MouseEvent mouseEvent) {
            Point2D.Double double_ = new Point2D.Double(mouseEvent.getPoint().getX(), mouseEvent.getPoint().getY());
            AffineTransform affineTransform = ApparatusPanel2.this.transformManager.getMouseTx();
            affineTransform.transform(double_, double_);
            int n = (int)(double_.getX() - mouseEvent.getPoint().getX());
            int n2 = (int)(double_.getY() - mouseEvent.getPoint().getY());
            mouseEvent.translatePoint(n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addMouseEvent(MouseEvent mouseEvent) {
            this.xformEventPt(mouseEvent);
            LinkedList linkedList = this.mouseEventList;
            synchronized (linkedList) {
                this.mouseEventList.add(mouseEvent);
            }
            if (this.clock != null && this.clock.isPaused()) {
                SwingUtilities.invokeLater(this.pausedEventListProcessor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processMouseEventList() {
            while (this.mouseEventList.size() > 0) {
                MouseEvent mouseEvent;
                LinkedList linkedList = this.mouseEventList;
                synchronized (linkedList) {
                    mouseEvent = (MouseEvent)this.mouseEventList.removeFirst();
                }
                this.handleMouseEvent(mouseEvent);
            }
        }

        private void handleMouseEvent(MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 500: {
                    this.handler.getMouseHandler().mouseClicked(mouseEvent);
                    break;
                }
                case 506: {
                    this.handler.getMouseHandler().mouseDragged(mouseEvent);
                    break;
                }
                case 504: {
                    this.handler.getMouseHandler().mouseEntered(mouseEvent);
                    break;
                }
                case 505: {
                    this.handler.getMouseHandler().mouseExited(mouseEvent);
                    break;
                }
                case 503: {
                    this.handler.getMouseHandler().mouseMoved(mouseEvent);
                    break;
                }
                case 501: {
                    this.handler.getMouseHandler().mousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    this.handler.getMouseHandler().mouseReleased(mouseEvent);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.addMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.addMouseEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.addMouseEvent(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.addMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.addMouseEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.addMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.addMouseEvent(mouseEvent);
        }
    }

    public class OffscreenBufferStrategy
    implements PaintStrategy {
        private BufferedImage bImg;
        protected ApparatusPanel2 apparatusPanel2;
        private AffineTransform IDENTITY = new AffineTransform();

        public OffscreenBufferStrategy(ApparatusPanel2 apparatusPanel22) {
            this.apparatusPanel2 = apparatusPanel22;
            this.componentResized();
        }

        public void paintImmediately() {
            Rectangle rectangle = new Rectangle(this.apparatusPanel2.getWidth(), this.apparatusPanel2.getHeight());
            this.apparatusPanel2.paintImmediately(rectangle);
            this.apparatusPanel2.rectangles.clear();
        }

        public void render(Graphics2D graphics2D, AffineTransform affineTransform) {
            if (this.bImg == null) {
                this.componentResized();
            }
            if (this.bImg != null) {
                Graphics2D graphics2D2 = (Graphics2D)this.bImg.getGraphics();
                graphics2D2.setColor(this.apparatusPanel2.getBackground());
                graphics2D2.fillRect(this.bImg.getMinX(), this.bImg.getMinY(), this.bImg.getWidth(), this.bImg.getHeight());
                ApparatusPanel2.this.setup(graphics2D2);
                graphics2D2.transform(affineTransform);
                this.apparatusPanel2.getGraphic().paint(graphics2D2);
                graphics2D.drawImage(this.bImg, this.IDENTITY, this.apparatusPanel2);
                graphics2D2.dispose();
            }
        }

        public void componentResized() {
            Rectangle rectangle = new Rectangle(ApparatusPanel2.this.getWidth(), ApparatusPanel2.this.getHeight());
            if (rectangle.width > 0 && rectangle.height > 0) {
                this.bImg = new BufferedImage(rectangle.width, rectangle.height, 1);
            }
        }
    }

    static interface PaintStrategy {
        public void paintImmediately();

        public void render(Graphics2D var1, AffineTransform var2);

        public void componentResized();
    }

    private class PanelResizeHandler
    extends ComponentAdapter {
        private PanelResizeHandler() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (!ApparatusPanel2.this.transformManager.isReferenceSizeSet()) {
                ApparatusPanel2.this.setReferenceSize();
            } else {
                double d;
                double d2;
                double d3;
                Rectangle rectangle = ApparatusPanel2.this.transformManager.getReferenceBounds();
                if (!rectangle.isEmpty() && (d3 = Math.min(d2 = (double)ApparatusPanel2.this.getWidth() / rectangle.getWidth(), d = (double)ApparatusPanel2.this.getHeight() / rectangle.getHeight())) > 0.0) {
                    ApparatusPanel2.this.setScale(d3);
                    ApparatusPanel2.this.determineCanvasSize();
                }
            }
            ApparatusPanel2.this.paintStrategy.componentResized();
        }
    }

    static class ScaledComponentLayout {
        private HashMap componentOrgLocationsMap = new HashMap();
        JComponent component;

        public ScaledComponentLayout(JComponent jComponent) {
            this.component = jComponent;
        }

        private void saveSwingComponentCoordinates(double d) {
            Component[] componentArray = this.component.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                Point point = component.getLocation();
                Dimension dimension = component.getPreferredSize();
                this.componentOrgLocationsMap.put(component, new Point((int)((double)point.x / d), (int)((double)point.y / d)));
            }
        }

        public void saveLocation(Component component) {
            this.componentOrgLocationsMap.put(component, new Point(component.getLocation()));
        }

        private void layoutSwingComponents(double d) {
        }
    }
}

