/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.controls;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class IntensitySlider
extends JPanel
implements ChangeListener {
    public static int HORIZONTAL = 0;
    public static int VERTICAL = 1;
    private static int DEFAULT_MIN = 0;
    private static int DEFAULT_MAX = 100;
    private final JPanel _containerPanel;
    private final JSlider _slider;
    private Color _color;
    private final EventListenerList _listenerList;

    public IntensitySlider(Color color, int n, Dimension dimension) {
        this._color = color;
        this._listenerList = new EventListenerList();
        this._containerPanel = new JPanel();
        this._containerPanel.setBackground(color);
        this._slider = new JSlider();
        this._slider.setOrientation(n);
        this._slider.setMinimum(DEFAULT_MIN);
        this._slider.setMaximum(DEFAULT_MAX);
        this._slider.setValue(DEFAULT_MIN);
        this._slider.setPreferredSize(dimension);
        this._slider.addChangeListener(this);
        this._slider.setPaintTicks(true);
        this.add(this._containerPanel);
        this._containerPanel.add(this._slider);
        this.setOpaque(false);
        this._containerPanel.setOpaque(false);
        this._slider.setOpaque(false);
        this.revalidate();
        this.repaint();
    }

    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        super.setBounds(n, n2, super.getPreferredSize().width, super.getPreferredSize().height);
    }

    public void setValue(int n) {
        this._slider.setValue(n);
    }

    public int getValue() {
        return this._slider.getValue();
    }

    public void setMaximum(int n) {
        this._slider.setMaximum(n);
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChangeEvent(new ChangeEvent(this));
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    public void paintComponent(Graphics graphics) {
        if (super.isVisible()) {
            Point2D.Double double_;
            Point2D.Double double_2;
            Rectangle2D.Double double_3;
            Rectangle2D.Double double_4;
            Rectangle2D.Double double_5;
            Rectangle2D.Double double_6;
            Graphics2D graphics2D = (Graphics2D)graphics;
            this._slider.setOpaque(false);
            this._containerPanel.setOpaque(false);
            Paint paint = graphics2D.getPaint();
            Stroke stroke = graphics2D.getStroke();
            JPanel jPanel = this._containerPanel;
            int n = ((Component)jPanel).getX();
            int n2 = ((Component)jPanel).getY();
            int n3 = ((Component)jPanel).getWidth();
            int n4 = ((Component)jPanel).getHeight();
            int n5 = 15;
            if (this._slider.getOrientation() == VERTICAL) {
                double_6 = new Rectangle2D.Double(n, n2 + n5, n3, n4 - 2 * n5);
                double_5 = new Rectangle2D.Double(n, n2, n3, ((double)n4 - double_6.getBounds2D().getHeight()) / 2.0);
                double_4 = new Rectangle2D.Double(n, double_6.getBounds2D().getMaxY(), n3, ((double)n4 - double_6.getBounds2D().getHeight()) / 2.0);
                double_3 = new Rectangle2D.Double(n, n2, n3, n4);
                double_2 = new Point2D.Double(n + n3 / 2, n2 + n5);
                double_ = new Point2D.Double(n + n3 / 2, n2 + n4 - n5);
            } else {
                double_6 = new Rectangle2D.Double(n + n5, n2, n3 - 2 * n5, n4);
                double_5 = new Rectangle2D.Double(double_6.getBounds2D().getMaxX(), n2, ((double)n3 - double_6.getBounds2D().getWidth()) / 2.0, n4);
                double_4 = new Rectangle2D.Double(n, n2, ((double)n3 - double_6.getBounds2D().getWidth()) / 2.0, n4);
                double_3 = new Rectangle2D.Double(n, n2, n3, n4);
                double_2 = new Point2D.Double(n + n3 - n5, n2 + n4 / 2);
                double_ = new Point2D.Double(n + n5, n2 + n4 / 2);
            }
            GradientPaint gradientPaint = new GradientPaint(double_2, this._color, double_, Color.BLACK);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.fill(double_4);
            graphics2D.setPaint(this._color);
            graphics2D.fill(double_5);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(double_6);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setPaint(Color.white);
            graphics2D.draw(double_3);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            super.paintComponent(graphics);
        }
    }
}

