/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.controls;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;

public class SpectrumSliderKnob
extends CompositePhetGraphic {
    private Point _location = new Point(0, 0);
    private Dimension _size;
    private double _angle;
    private PhetShapeGraphic knobShape;

    public SpectrumSliderKnob(Component component, Dimension dimension, double d) {
        super(component);
        this._size = new Dimension(dimension);
        this._angle = d;
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.setRenderingHints(renderingHints);
        this.knobShape = new PhetShapeGraphic(component, null, null);
        this.knobShape.setPaint(Color.WHITE);
        this.knobShape.setStroke(new BasicStroke(1.0f));
        this.knobShape.setBorderColor(Color.BLACK);
        this.addGraphic(this.knobShape);
        this.updateShape();
    }

    public PhetGraphic getPhetGraphic() {
        return this;
    }

    public void setLocation(Point point) {
        super.translate(-this._location.x, -this._location.y);
        this._location = new Point(point);
        super.translate(point.x, point.y);
        this.updateShape();
    }

    public void setLocation(int n, int n2) {
        this.setLocation(new Point(n, n2));
    }

    public Point getLocation() {
        return new Point(this._location);
    }

    public void setSize(Dimension dimension) {
        this._size = new Dimension(dimension);
        this.updateShape();
    }

    public void setAngle(double d) {
        this._angle = d;
        this.updateShape();
    }

    protected void updateShape() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(-0.5f * (float)this._size.width, 0.3f * (float)this._size.height);
        generalPath.lineTo(-0.5f * (float)this._size.width, 1.0f * (float)this._size.height);
        generalPath.lineTo(0.5f * (float)this._size.width, 1.0f * (float)this._size.height);
        generalPath.lineTo(0.5f * (float)this._size.width, 0.3f * (float)this._size.height);
        generalPath.closePath();
        GeneralPath generalPath2 = generalPath;
        this.knobShape.setShape(generalPath2);
    }

    public void setPaint(Color color) {
        this.knobShape.setPaint(color);
    }
}

