/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.collision;

import edu.colorado.phet.common.collision.Collidable;
import edu.colorado.phet.common.collision.CollidableAdapter;
import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import java.awt.geom.Point2D;

public class SphericalBody
extends Body
implements Collidable {
    private double radius;
    private CollidableAdapter collidableAdapter;

    public SphericalBody(double d) {
        this(new Point2D.Double(), new Vector2D(), new Vector2D(), 0.0, d);
    }

    protected SphericalBody(Point2D point2D, Vector2D vector2D, Vector2D vector2D2, double d, double d2) {
        super(point2D, vector2D, vector2D2, d, 0.0);
        this.radius = d2;
        this.collidableAdapter = new CollidableAdapter(this);
    }

    public double getMomentOfInertia() {
        return this.getMass() * this.radius * this.radius * 2.0 / 5.0;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        this.radius = d;
    }

    public Point2D getCenter() {
        return this.getPosition();
    }

    public Point2D getPositionPrev() {
        if (this.collidableAdapter == null) {
            System.out.println("SphericalBody.getPositionPrev");
        }
        return this.collidableAdapter.getPositionPrev();
    }

    public void stepInTime(double d) {
        this.collidableAdapter.stepInTime(d);
        super.stepInTime(d);
    }
}

