/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.collision;

import edu.colorado.phet.common.collision.Collision;
import edu.colorado.phet.common.collision.SphericalBody;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.Particle;
import java.awt.geom.Point2D;

public class SphereSphereCollision
implements Collision {
    private SphericalBody sphereA;
    private SphericalBody sphereB;
    private Vector2D loa = new Vector2D();
    static Vector2D vRel = new Vector2D();
    static Vector2D n = new Vector2D();

    public SphereSphereCollision(SphericalBody sphericalBody, SphericalBody sphericalBody2) {
        this.sphereA = sphericalBody;
        this.sphereB = sphericalBody2;
    }

    protected Vector2D getLoa(Particle particle, Particle particle2) {
        Point2D point2D = particle.getPosition();
        Point2D point2D2 = particle2.getPosition();
        this.loa.setX(point2D.getX() - point2D2.getX());
        this.loa.setY(point2D.getY() - point2D2.getY());
        return this.loa;
    }

    public void collide() {
        double d = Math.sqrt(this.sphereA.getPosition().distanceSq(this.sphereB.getPosition()));
        double d2 = this.sphereA.getRadius() / d;
        Point2D.Double double_ = new Point2D.Double(this.sphereA.getPosition().getX() + (this.sphereB.getPosition().getX() - this.sphereA.getPosition().getX()) * d2, this.sphereA.getPosition().getY() + (this.sphereB.getPosition().getY() - this.sphereA.getPosition().getY()) * d2);
        this.doCollision(this.getLoa(this.sphereA, this.sphereB), double_);
    }

    public void doCollision(Vector2D vector2D, Point2D point2D) {
        double d = this.sphereA.getKineticEnergy() + this.sphereB.getKineticEnergy();
        Vector2D vector2D2 = new Vector2D(point2D.getX() - this.sphereA.getPosition().getX(), point2D.getY() - this.sphereA.getPosition().getY());
        Vector2D vector2D3 = new Vector2D(point2D.getX() - this.sphereB.getPosition().getX(), point2D.getY() - this.sphereB.getPosition().getY());
        n.setComponents(vector2D.getX(), vector2D.getY());
        n.normalize();
        vRel.setComponents(this.sphereA.getVelocity().getX(), this.sphereA.getVelocity().getY());
        vRel.subtract(this.sphereB.getVelocity());
        Vector2D vector2D4 = new Vector2D(vector2D.getY(), -vector2D.getX());
        Point2D point2D2 = this.sphereB.getPositionPrev();
        double d2 = point2D2.distance(point2D);
        double d3 = this.sphereB.getRadius() / d2;
        double d4 = this.sphereB.getPositionPrev().distance(this.sphereA.getPositionPrev()) < this.sphereA.getRadius() ? -this.sphereB.getRadius() : this.sphereB.getRadius();
        double d5 = n.getX() * d4;
        double d6 = n.getY() * d4;
        Point2D.Double double_ = new Point2D.Double(point2D.getX() - d5, point2D.getY() - d6);
        Point2D point2D3 = MathUtil.reflectPointAcrossLine(this.sphereB.getPosition(), double_, Math.atan2(vector2D4.getY(), vector2D4.getX()));
        this.sphereB.setPosition(point2D3);
        Point2D point2D4 = this.sphereA.getPositionPrev();
        double d7 = point2D4.distance(point2D);
        double d8 = this.sphereA.getRadius() / d7;
        Point2D.Double double_2 = new Point2D.Double(point2D.getX() - (point2D.getX() - point2D4.getX()) * d8, point2D.getY() - (point2D.getY() - point2D4.getY()) * d8);
        double d9 = -this.sphereA.getRadius();
        double d10 = n.getX() * d9;
        double d11 = n.getY() * d9;
        Point2D point2D5 = MathUtil.reflectPointAcrossLine(this.sphereA.getPosition(), double_2, Math.atan2(vector2D4.getY(), vector2D4.getX()));
        this.sphereA.setPosition(point2D5);
        double d12 = vRel.dot(n);
        double d13 = 1.0;
        double d14 = -d12 * (1.0 + d13);
        double d15 = 1.0 / this.sphereA.getMass() + 1.0 / this.sphereB.getMass();
        double d16 = d14 / d15;
        Vector2D vector2D5 = new Vector2D(n.getX(), n.getY()).scale(d16 / this.sphereA.getMass());
        this.sphereA.getVelocity().add(vector2D5);
        Vector2D vector2D6 = new Vector2D(n.getX(), n.getY()).scale(-d16 / this.sphereB.getMass());
        this.sphereB.getVelocity().add(vector2D6);
    }
}

