/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.ladybugmotion2d.canvas;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.ladybugmotion2d.LadybugColorSet$;
import edu.colorado.phet.ladybugmotion2d.LadybugDefaults$;
import edu.colorado.phet.ladybugmotion2d.LadybugMotion2DResources$;
import edu.colorado.phet.ladybugmotion2d.controlpanel.VectorVisibilityModel;
import edu.colorado.phet.ladybugmotion2d.model.Ladybug;
import edu.colorado.phet.scalacommon.Predef$;
import edu.colorado.phet.scalacommon.math.Vector2D;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Point2D;
import scala.Function0;
import scala.Serializable;
import scala.runtime.BoxedUnit;

public class ArrowSetNode
extends PNode {
    private final Ladybug ladybug;
    private final ModelViewTransform2D transform;
    private final VectorVisibilityModel vectorVisibilityModel;
    private final LabeledArrowNode velocityNode;
    private final LabeledArrowNode accelNode;

    public LabeledArrowNode velocityNode() {
        return this.velocityNode;
    }

    public LabeledArrowNode accelNode() {
        return this.accelNode;
    }

    public void update() {
        Point viewPosition = this.transform.modelToView(Predef$.MODULE$.vector2DToPoint(this.ladybug.getPosition()));
        Point2D viewVelocity = this.transform.modelToViewDifferentialDouble(Predef$.MODULE$.vector2DToPoint(this.ladybug.getVelocity()));
        double vectorScale = 0.66;
        Vector2D velTip = Predef$.MODULE$.pointToVector2D(viewPosition).$plus(Predef$.MODULE$.pointToVector2D(viewVelocity).$times(0.66));
        this.velocityNode().setTipAndTailLocations(velTip, Predef$.MODULE$.pointToVector2D(viewPosition));
        Point2D viewAccel = this.transform.modelToViewDifferentialDouble(Predef$.MODULE$.vector2DToPoint(this.ladybug.getAcceleration()));
        this.accelNode().setTipAndTailLocations(Predef$.MODULE$.pointToVector2D(viewPosition).$plus(Predef$.MODULE$.pointToVector2D(viewAccel).$times(0.66).$times(LadybugDefaults$.MODULE$.ACCEL_VECTOR_SCALE())), Predef$.MODULE$.pointToVector2D(viewPosition));
        this.accelNode().setVisible(this.vectorVisibilityModel.accelerationVectorVisible());
        this.velocityNode().setVisible(this.vectorVisibilityModel.velocityVectorVisible());
    }

    public ArrowSetNode(Ladybug ladybug, ModelViewTransform2D transform, VectorVisibilityModel vectorVisibilityModel) {
        this.ladybug = ladybug;
        this.transform = transform;
        this.vectorVisibilityModel = vectorVisibilityModel;
        this.velocityNode = new LabeledArrowNode(this, LadybugColorSet$.MODULE$.velocity(), LadybugMotion2DResources$.MODULE$.getLocalizedString("model.velocity"));
        this.accelNode = new LabeledArrowNode(this, LadybugColorSet$.MODULE$.acceleration(), LadybugMotion2DResources$.MODULE$.getLocalizedString("model.acceleration"));
        this.addChild(this.velocityNode());
        this.addChild(this.accelNode());
        ladybug.addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final ArrowSetNode $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.update();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.update();
        vectorVisibilityModel.addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final ArrowSetNode $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.update();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.setPickable(false);
        this.setChildrenPickable(false);
    }

    public class LabeledArrowNode
    extends PNode {
        private final double arrowWidth;
        private final ArrowNode arrowNode;
        private final PText labelNode;
        public final ArrowSetNode $outer;

        public double arrowWidth() {
            return this.arrowWidth;
        }

        public ArrowNode arrowNode() {
            return this.arrowNode;
        }

        public PText labelNode() {
            return this.labelNode;
        }

        public void setTipAndTailLocations(Vector2D a, Vector2D b) {
            this.arrowNode().setTipAndTailLocations(Predef$.MODULE$.vector2DToPoint(a), Predef$.MODULE$.vector2DToPoint(b));
            this.labelNode().setOffset(Predef$.MODULE$.vector2DToPoint(a));
            this.labelNode().setVisible(this.labelNode().getFullBounds().width < a.$minus(b).magnitude() * (double)5);
        }

        public LabeledArrowNode(ArrowSetNode $outer, Color color, String name) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.arrowWidth = 22.5;
            this.arrowNode = new ArrowNode(new Point2D.Double(0.0, 0.0), new Point2D.Double(200.0, 200.0), this.arrowWidth(), this.arrowWidth(), this.arrowWidth() * 2.0 / 3.0, 2.0, true);
            this.arrowNode().setPaint(color);
            this.arrowNode().setStroke(new BasicStroke(1.0f));
            this.arrowNode().setStrokePaint(Color.black);
            this.labelNode = new PText(name);
            this.labelNode().setFont(new PhetFont(24));
            this.addChild(this.arrowNode());
            this.addChild(this.labelNode());
        }
    }
}

