/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.statistics;

import edu.colorado.phet.common.phetcommon.application.ISimInfo;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.SessionCounter;
import edu.colorado.phet.common.phetcommon.application.SoftwareAgreementManager;
import edu.colorado.phet.common.phetcommon.statistics.SessionMessage;
import edu.colorado.phet.common.phetcommon.statistics.StatisticsMessage;
import edu.colorado.phet.common.phetcommon.statistics.StatisticsMessageSender;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class StatisticsManager {
    private static final Object MONITOR = new Object();
    public static StatisticsManager instance;
    private final ISimInfo simInfo;
    private final Frame parentFrame;
    private final Vector messageQueue = new Vector();
    private final StatisticsThread statisticsThread = new StatisticsThread();
    private final StatisticsMessageSender statisticsService = new StatisticsMessageSender();
    private final ArrayList listeners = new ArrayList();
    private boolean applicationStartedCalled = false;

    private StatisticsManager(PhetApplication phetApplication) {
        this.simInfo = phetApplication.getSimInfo();
        this.parentFrame = phetApplication.getPhetFrame();
        this.statisticsThread.start();
    }

    public static StatisticsManager initInstance(PhetApplication phetApplication) {
        if (instance != null) {
            throw new RuntimeException("StatisticsManager instance is already initialized");
        }
        instance = new StatisticsManager(phetApplication);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageImpl(StatisticsMessage statisticsMessage) {
        if (StatisticsManager.isStatisticsEnabled()) {
            this.messageQueue.add(statisticsMessage);
            Object object = MONITOR;
            synchronized (object) {
                MONITOR.notifyAll();
            }
        }
    }

    private void sendAllMessages() {
        while (this.messageQueue.size() > 0) {
            StatisticsMessage statisticsMessage = (StatisticsMessage)this.messageQueue.get(0);
            boolean bl = this.statisticsService.sendMessage(statisticsMessage);
            this.messageQueue.remove(statisticsMessage);
            this.notifyListeners(bl, statisticsMessage);
        }
    }

    public static boolean isStatisticsEnabled() {
        return instance != null && StatisticsManager.instance.simInfo.isStatisticsEnabled();
    }

    public static void sendMessage(StatisticsMessage statisticsMessage) {
        if (StatisticsManager.isStatisticsEnabled()) {
            instance.sendMessageImpl(statisticsMessage);
        }
    }

    public void start() {
        if (this.applicationStartedCalled) {
            throw new IllegalStateException("attempted to call applicationStarted more than once");
        }
        this.applicationStartedCalled = true;
        if (StatisticsManager.isStatisticsEnabled()) {
            SessionCounter sessionCounter = SessionCounter.initInstance(this.simInfo.getProjectName(), this.simInfo.getFlavor());
            if (sessionCounter != null) {
                sessionCounter.incrementCounts();
            }
            final SessionMessage sessionMessage = SessionMessage.initInstance(this.simInfo);
            SoftwareAgreementManager.validate(this.parentFrame, sessionMessage);
            this.addListener(new StatisticsManagerListener(){

                public void receiveResponse(boolean bl, StatisticsMessage statisticsMessage) {
                    if (bl && statisticsMessage == sessionMessage) {
                        SessionCounter.getInstance().resetCountSince();
                    }
                }
            });
            StatisticsManager.sendMessage(sessionMessage);
        }
    }

    private synchronized void addListener(StatisticsManagerListener statisticsManagerListener) {
        this.listeners.add(statisticsManagerListener);
    }

    private synchronized void notifyListeners(boolean bl, StatisticsMessage statisticsMessage) {
        ArrayList arrayList = new ArrayList(this.listeners);
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            ((StatisticsManagerListener)iterator2.next()).receiveResponse(bl, statisticsMessage);
        }
    }

    private static interface StatisticsManagerListener {
        public void receiveResponse(boolean var1, StatisticsMessage var2);
    }

    public class StatisticsRunnable
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                StatisticsManager.this.sendAllMessages();
                Object object = MONITOR;
                synchronized (object) {
                    try {
                        MONITOR.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }
    }

    private class StatisticsThread
    extends Thread {
        private StatisticsThread() {
            super(new StatisticsRunnable());
        }
    }
}

