/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.model.property;

import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.util.logging.LoggingUtils;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObservableProperty<T>
implements Cloneable {
    private static final Logger LOGGER = LoggingUtils.getLogger(ObservableProperty.class.getCanonicalName());
    private final ArrayList<SimpleObserver> simpleObservers = new ArrayList();
    private final ArrayList<VoidFunction1<T>> newValueObservers = new ArrayList();
    private final ArrayList<ChangeObserver<T>> newAndOldValueObservers = new ArrayList();
    private T oldValue;

    public ObservableProperty(T t) {
        this.oldValue = t;
    }

    public void addObserver(SimpleObserver simpleObserver, boolean bl) {
        this.simpleObservers.add(simpleObserver);
        if (bl) {
            simpleObserver.update();
        }
    }

    private void notifyObservers(T t, T t2) {
        this.notifySimpleObservers();
        this.notifyNewValueObservers(t);
        this.notifyNewAndOldValueObservers(t, t2);
    }

    private void notifySimpleObservers() {
        for (SimpleObserver simpleObserver : new ArrayList<SimpleObserver>(this.simpleObservers)) {
            simpleObserver.update();
        }
    }

    private void notifyNewValueObservers(T t) {
        for (VoidFunction1<T> voidFunction1 : new ArrayList<VoidFunction1<T>>(this.newValueObservers)) {
            voidFunction1.apply(t);
        }
    }

    private void notifyNewAndOldValueObservers(T t, T t2) {
        for (ChangeObserver<T> changeObserver : new ArrayList<ChangeObserver<T>>(this.newAndOldValueObservers)) {
            changeObserver.update(t, t2);
        }
    }

    public void addObserver(SimpleObserver simpleObserver) {
        this.addObserver(simpleObserver, true);
    }

    public abstract T get();

    public String toString() {
        return this.get().toString();
    }

    public void notifyIfChanged() {
        T t = this.get();
        if (!t.equals(this.oldValue)) {
            T t2 = this.oldValue;
            this.oldValue = t;
            this.notifyObservers(t, t2);
        }
    }

    static {
        LOGGER.setLevel(Level.INFO);
    }
}

