/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.resources.PhetResources;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Locale;
import javax.swing.JTextField;

public class PhetFont
extends Font {
    private static final Font FALLBACK_FONT = new JTextField().getFont().deriveFont(0, 12.0f);
    private static final Font DEFAULT_FONT = PhetFont.createDefaultFont();

    public PhetFont() {
        this(PhetFont.getDefaultFontSize());
    }

    public PhetFont(int n) {
        this(PhetFont.getDefaultFontStyle(), n);
    }

    public PhetFont(int n, int n2) {
        super(PhetFont.getDefaultFontName(), n, n2);
    }

    public static String getDefaultFontName() {
        return DEFAULT_FONT.getFontName();
    }

    public static int getDefaultFontSize() {
        return DEFAULT_FONT.getSize();
    }

    public static int getDefaultFontStyle() {
        return DEFAULT_FONT.getStyle();
    }

    private static Font createDefaultFont() {
        return PhetFont.getPreferredFont(PhetResources.readLocale());
    }

    public static Font getPreferredFont(Locale locale, int n, int n2) {
        Font font = null;
        String[] stringArray = PhetCommonResources.getPreferredFontNames(locale);
        if (stringArray != null) {
            Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            for (int i = 0; font == null && i < stringArray.length; ++i) {
                String string = stringArray[i];
                for (int j = 0; font == null && j < fontArray.length; ++j) {
                    Font font2 = fontArray[j];
                    if (!font2.getFontName().equals(string)) continue;
                    font = font2.deriveFont(n, n2);
                }
            }
        }
        if (font == null) {
            font = FALLBACK_FONT.deriveFont(n, n2);
        }
        return font;
    }

    public static Font getPreferredFont(Locale locale) {
        return PhetFont.getPreferredFont(locale, FALLBACK_FONT.getStyle(), FALLBACK_FONT.getSize());
    }
}

