/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.updates;

import edu.colorado.phet.common.phetcommon.application.ISimInfo;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.VersionInfoQuery;
import edu.colorado.phet.common.phetcommon.dialogs.ErrorDialog;
import edu.colorado.phet.common.phetcommon.files.PhetInstallation;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.resources.PhetInstallerVersion;
import edu.colorado.phet.common.phetcommon.updates.dialogs.InstallerManualUpdateDialog;
import edu.colorado.phet.common.phetcommon.updates.dialogs.NoUpdateDialog;
import edu.colorado.phet.common.phetcommon.updates.dialogs.SimManualUpdateDialog;
import edu.colorado.phet.common.phetcommon.updates.dialogs.UpdateErrorDialog;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import java.awt.Frame;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import javax.swing.SwingUtilities;

public class ManualUpdatesManager {
    private static final String ERROR_INTERNET_CONNECTION = PhetCommonResources.getString("Common.updates.error.internetConnection");
    private static ManualUpdatesManager instance;
    private final PhetApplication app;

    public static ManualUpdatesManager getInstance() {
        return instance;
    }

    public void checkForSimUpdates() {
        final ISimInfo iSimInfo = this.app.getSimInfo();
        final PhetFrame phetFrame = this.app.getPhetFrame();
        VersionInfoQuery versionInfoQuery = new VersionInfoQuery(iSimInfo, false);
        versionInfoQuery.addListener(new VersionInfoQuery.VersionInfoQueryListener(){

            public void done(final VersionInfoQuery.Response response) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        VersionInfoQuery.SimResponse simResponse = response.getSimResponse();
                        if (simResponse != null && simResponse.isUpdateRecommended()) {
                            new SimManualUpdateDialog(phetFrame, iSimInfo, simResponse.getVersion()).setVisible(true);
                        } else {
                            new NoUpdateDialog.SimNoUpdateDialog(phetFrame, iSimInfo.getName(), iSimInfo.getVersion()).setVisible(true);
                        }
                    }
                });
            }

            public void exception(Exception exception) {
                ManualUpdatesManager.this.handleException(phetFrame, exception);
            }
        });
        versionInfoQuery.send();
    }

    public void checkForInstallerUpdates() {
        final PhetInstallerVersion phetInstallerVersion = PhetInstallation.getInstance().getInstallerVersion();
        final PhetFrame phetFrame = this.app.getPhetFrame();
        VersionInfoQuery versionInfoQuery = new VersionInfoQuery(phetInstallerVersion, false);
        versionInfoQuery.addListener(new VersionInfoQuery.VersionInfoQueryListener(){

            public void done(final VersionInfoQuery.Response response) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        VersionInfoQuery.InstallerResponse installerResponse = response.getInstallerResponse();
                        if (installerResponse != null && installerResponse.isUpdateRecommended()) {
                            PhetInstallerVersion phetInstallerVersion = installerResponse.getVersion();
                            InstallerManualUpdateDialog installerManualUpdateDialog = new InstallerManualUpdateDialog(phetFrame, phetInstallerVersion, phetInstallerVersion);
                            installerManualUpdateDialog.setVisible(true);
                        } else {
                            NoUpdateDialog.InstallerNoUpdateDialog installerNoUpdateDialog = new NoUpdateDialog.InstallerNoUpdateDialog(phetFrame, phetInstallerVersion);
                            installerNoUpdateDialog.setVisible(true);
                        }
                    }
                });
            }

            public void exception(Exception exception) {
                ManualUpdatesManager.this.handleException(phetFrame, exception);
            }
        });
        versionInfoQuery.send();
    }

    private void handleException(Frame frame, Exception exception) {
        if (exception instanceof UnknownHostException) {
            Object[] objectArray = new Object[]{"http://phet.colorado.edu"};
            String string = MessageFormat.format(ERROR_INTERNET_CONNECTION, objectArray);
            ErrorDialog errorDialog = new ErrorDialog(frame, string);
            errorDialog.setVisible(true);
        } else {
            UpdateErrorDialog updateErrorDialog = new UpdateErrorDialog(frame, exception);
            updateErrorDialog.setVisible(true);
        }
    }
}

