/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.files;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.resources.PhetInstallerVersion;
import edu.colorado.phet.common.phetcommon.resources.PhetProperties;
import edu.colorado.phet.common.phetcommon.servicemanager.PhetServiceManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;

public class PhetInstallation {
    private static PhetInstallation instance;
    private final PhetProperties properties = PhetInstallation.readProperties();

    public static PhetInstallation getInstance() {
        if (instance == null) {
            instance = new PhetInstallation();
        }
        return instance;
    }

    private PhetInstallation() {
    }

    public PhetInstallerVersion getInstallerVersion() {
        String string = "installer.creation.date.epoch.seconds";
        long l = this.properties.getLong(string, -1L);
        if (l == -1L) {
            PhetInstallation.warnMissingKey(string);
        }
        return new PhetInstallerVersion(l);
    }

    public File getInstalledJarFile() {
        File file = null;
        URL uRL = PhetServiceManager.getCodeBase();
        if (uRL != null && uRL.getProtocol().equals("file")) {
            String string = uRL.getPath();
            String string2 = new File(string).getName();
            file = new File(string, PhetApplicationConfig.getProjectJarName(string2));
        }
        return file;
    }

    public static boolean exists() {
        boolean bl = false;
        File file = PhetInstallation.getPropertiesFile();
        if (file != null) {
            bl = file.exists();
        }
        return bl;
    }

    private static PhetProperties readProperties() {
        PhetProperties phetProperties = new PhetProperties();
        File file = PhetInstallation.getPropertiesFile();
        if (file != null && file.exists()) {
            try {
                phetProperties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return phetProperties;
    }

    private static File getPropertiesFile() {
        File file;
        File file2;
        String string;
        String string2;
        String string3;
        File file3;
        File file4 = null;
        URL uRL = PhetServiceManager.getCodeBase();
        if (uRL != null && uRL.getProtocol().equals("file") && (file3 = new File(string3 = uRL.getPath(), string2 = (string = new File(string3).getName()) + "_all.jar")).exists() && (file2 = file3.getParentFile()) != null && (file = file2.getParentFile()) != null) {
            file4 = new File(file.getAbsolutePath(), "phet-installation.properties");
        }
        return file4;
    }

    private static void warnMissingKey(String string) {
        System.err.println("WARNING: phet-installation.properties is missing required key " + string);
    }
}

