/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.resources.PhetProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class SoftwareAgreement {
    private static SoftwareAgreement instance;
    private final int version;
    private String content;

    private SoftwareAgreement() {
        PhetProperties phetProperties = this.readProperties();
        this.version = phetProperties.getInt("version", -1);
        try {
            this.content = this.readContent();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String readContent() throws IOException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("software-agreement.htm");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = "";
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            string = string + string2 + "\n";
            string2 = bufferedReader.readLine();
        }
        return string;
    }

    public static SoftwareAgreement getInstance() {
        if (instance == null) {
            instance = new SoftwareAgreement();
        }
        return instance;
    }

    public String getContent() {
        return this.content;
    }

    private PhetProperties readProperties() {
        PhetProperties phetProperties = new PhetProperties();
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("software-agreement.properties");
        if (inputStream != null) {
            try {
                phetProperties.load(inputStream);
            }
            catch (IOException iOException) {
                System.err.println("exception reading software agreement: software-agreement.properties");
                iOException.printStackTrace();
            }
        } else {
            System.err.println("missing software agreement: software-agreement.properties");
        }
        return phetProperties;
    }
}

