/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.view;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationEvent;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationListener;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.controller.IdealGasModule;
import edu.colorado.phet.idealgas.model.Box2D;
import edu.colorado.phet.idealgas.model.PressureSensingBox;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class BoxDoorGraphic
extends CompositePhetGraphic
implements SimpleObserver,
IdealGasModule.ResetListener,
Box2D.ChangeListener,
PressureSensingBox.ChangeListener {
    private int x;
    private int y;
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;
    private PressureSensingBox box;
    private PhetImageGraphic imageGraphic;
    private PhetShapeGraphic highlightGraphic;
    private double openingMaxX;
    private Point2D[] opening = new Point2D[2];
    private PhetShapeGraphic doorShapeGraphic;
    private double blowOffRotation = 0.0;
    private boolean isAnimating = false;

    public BoxDoorGraphic(Component component, int n, int n2, int n3, int n4, int n5, int n6, PressureSensingBox pressureSensingBox, Color color, IdealGasModule idealGasModule) {
        super(component);
        BufferedImage bufferedImage = null;
        bufferedImage = IdealGasResources.getImage("knob-and-door.gif");
        this.imageGraphic = new PhetImageGraphic(component, bufferedImage);
        this.addGraphic(this.imageGraphic);
        Rectangle rectangle = new Rectangle(this.imageGraphic.getWidth(), 12);
        this.doorShapeGraphic = new PhetShapeGraphic(component, rectangle, color);
        this.addGraphic(this.doorShapeGraphic);
        this.highlightGraphic = new PhetShapeGraphic(component, new Rectangle(this.imageGraphic.getBounds()), new BasicStroke(1.0f), Color.red);
        this.highlightGraphic.setVisible(false);
        this.addGraphic(this.highlightGraphic);
        this.x = n;
        this.y = n2;
        this.minX = n3;
        this.minY = n4;
        this.maxX = n5;
        this.maxY = n6;
        this.box = pressureSensingBox;
        this.openingMaxX = (double)n + this.imageGraphic.getBounds().getWidth();
        pressureSensingBox.addObserver(this);
        pressureSensingBox.addChangeListener(this);
        pressureSensingBox.addChangeListener(this);
        this.setCursor(Cursor.getPredefinedCursor(11));
        this.addTranslationListener(new DoorTranslator());
        idealGasModule.addResetListener(this);
        idealGasModule.getClock().addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                BoxDoorGraphic.this.stepAnimation();
            }
        });
    }

    public void fireMouseEntered(MouseEvent mouseEvent) {
        super.fireMouseEntered(mouseEvent);
        this.highlightGraphic.setVisible(true);
        this.setBoundsDirty();
        this.repaint();
    }

    public void fireMouseExited(MouseEvent mouseEvent) {
        super.fireMouseExited(mouseEvent);
        this.highlightGraphic.setVisible(false);
        this.setBoundsDirty();
        this.repaint();
    }

    public void translateDoor(double d, double d2) {
        this.minX = (int)(this.box.getMinX() - this.imageGraphic.getBounds().getWidth());
        this.x = (int)Math.min((double)this.maxX, Math.max((double)this.minX, (double)this.x + d));
        this.y = (int)Math.min((double)this.maxY, Math.max((double)this.minY, (double)this.y + d2));
        this.imageGraphic.setLocation(this.x, this.y - (int)this.imageGraphic.getBounds().getHeight());
        this.opening[0] = new Point2D.Double((double)this.x + this.imageGraphic.getBounds().getWidth(), this.box.getMinY());
        this.opening[1] = new Point2D.Double(this.openingMaxX, this.box.getMinY());
        this.setBoundsDirty();
        this.repaint();
    }

    public void update() {
        if (this.minY != (int)this.box.getMinY() || this.minX != (int)this.box.getMinX()) {
            this.translateDoor(0.0, 0.0);
            this.minX = (int)this.box.getMinX();
            this.minY = (int)this.box.getMinY();
            this.maxY = (int)this.box.getMinY();
            this.imageGraphic.setLocation((int)this.imageGraphic.getBounds().getMinX(), this.minY - (int)this.imageGraphic.getBounds().getHeight() - 1);
            this.doorShapeGraphic.setLocation((int)this.imageGraphic.getLocation().getX(), (int)this.imageGraphic.getLocation().getY() + 13);
            this.highlightGraphic.setLocation(this.imageGraphic.getLocation());
            this.setBoundsDirty();
            this.repaint();
        }
    }

    protected PhetGraphic getHandler(Point point) {
        if (this.isVisible() && this.imageGraphic.contains(point.x, point.y)) {
            return this;
        }
        return null;
    }

    public void setColor(Color color) {
        this.doorShapeGraphic.setPaint(color);
    }

    public void boundsChanged(Box2D.ChangeEvent changeEvent) {
        double d = (int)(this.box.getMinX() - this.imageGraphic.getBounds().getWidth());
        if (d > (double)this.minX) {
            this.translateDoor(d - (double)this.minX, 0.0);
        }
    }

    public void isVolumeFixedChanged(Box2D.ChangeEvent changeEvent) {
    }

    public void resetOccurred(IdealGasModule.ResetEvent resetEvent) {
        this.closeDoor();
    }

    public void closeDoor() {
        this.stopAnimation();
        this.setTransform(new AffineTransform());
        this.setLocation(0, 0);
        this.translateDoor(Double.MAX_VALUE, 0.0);
    }

    public void stateChanged(PressureSensingBox.ChangeEvent changeEvent) {
        if (!changeEvent.getPressureSensingBox().isPressureSafe() && !this.isAnimating) {
            this.openBox();
            this.startAnimation();
        }
    }

    private void openBox() {
        this.opening[0] = new Point2D.Double(this.x, this.box.getMinY());
        this.opening[1] = new Point2D.Double(this.openingMaxX, this.box.getMinY());
        this.box.setOpening(this.opening);
    }

    private void startAnimation() {
        this.isAnimating = true;
        this.blowOffRotation = 0.0;
    }

    private void stopAnimation() {
        this.isAnimating = false;
    }

    private void stepAnimation() {
        if (this.isAnimating) {
            this.blowOffRotation -= 10.0;
            this.setTransform(AffineTransform.getRotateInstance(Math.toRadians(this.blowOffRotation), this.doorShapeGraphic.getLocation().getX(), this.doorShapeGraphic.getLocation().getY()));
            this.setLocation((int)this.getLocation().getX() - 1, (int)this.getLocation().getY() - 8);
        }
    }

    private class DoorTranslator
    implements TranslationListener {
        public void translationOccurred(TranslationEvent translationEvent) {
            BoxDoorGraphic.this.translateDoor(translationEvent.getDx(), translationEvent.getDy());
            BoxDoorGraphic.this.box.setOpening(BoxDoorGraphic.this.opening);
        }

        public DoorTranslator() {
            BoxDoorGraphic.this.translate(0.0, 0.0);
        }
    }
}

