/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.model;

import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.idealgas.collision.CollidableBody;
import edu.colorado.phet.idealgas.collision.SphericalBody;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.HeavySpecies;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import edu.colorado.phet.idealgas.model.LightSpecies;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Random;

public class HollowSphere
extends SphericalBody {
    private ArrayList containedBodies = new ArrayList();
    private ArrayList listeners = new ArrayList();
    public Point2D contactPt;
    private Random random = new Random();

    public HollowSphere(Point2D point2D, MutableVector2D mutableVector2D, MutableVector2D mutableVector2D2, double d, double d2) {
        super(point2D, mutableVector2D, mutableVector2D2, d, d2);
    }

    public void addContainedBody(Body body) {
        this.containedBodies.add(body);
        if (body instanceof GasMolecule) {
            GasMolecule gasMolecule = (GasMolecule)body;
            MoleculeEvent moleculeEvent = new MoleculeEvent(this, gasMolecule);
            for (int i = 0; i < this.listeners.size(); ++i) {
                Object e = this.listeners.get(i);
                if (!(e instanceof HollowSphereListener)) continue;
                HollowSphereListener hollowSphereListener = (HollowSphereListener)e;
                hollowSphereListener.moleculeAdded(moleculeEvent);
            }
        }
    }

    public void removeContainedBody(Body body) {
        this.containedBodies.remove(body);
        if (body instanceof GasMolecule) {
            GasMolecule gasMolecule = (GasMolecule)body;
            MoleculeEvent moleculeEvent = new MoleculeEvent(this, gasMolecule);
            for (int i = 0; i < this.listeners.size(); ++i) {
                Object e = this.listeners.get(i);
                if (!(e instanceof HollowSphereListener)) continue;
                HollowSphereListener hollowSphereListener = (HollowSphereListener)e;
                hollowSphereListener.moleculeRemoved(moleculeEvent);
            }
        }
    }

    public boolean containsBody(Body body) {
        return this.containedBodies.contains(body);
    }

    public void collideWithParticle(CollidableBody collidableBody) {
        if (this.contains(collidableBody) && !this.containsBody(collidableBody)) {
            MutableVector2D mutableVector2D = new MutableVector2D(collidableBody.getPosition().getX() - this.getPosition().getX(), collidableBody.getPosition().getY() - this.getPosition().getY());
            mutableVector2D.normalize();
            mutableVector2D.scale(this.getRadius() * 1.2);
            collidableBody.setPosition(this.getPosition().getX() + mutableVector2D.getX(), this.getPosition().getY() + mutableVector2D.getY());
            return;
        }
        if (!this.contains(collidableBody) && this.containsBody(collidableBody)) {
            MutableVector2D mutableVector2D = new MutableVector2D(collidableBody.getPosition().getX() - this.getPosition().getX(), collidableBody.getPosition().getY() - this.getPosition().getY());
            mutableVector2D.normalize();
            mutableVector2D.scale(this.getRadius() * 0.8);
            collidableBody.setPosition(this.getPosition().getX() + mutableVector2D.getX(), this.getPosition().getY() + mutableVector2D.getY());
            return;
        }
    }

    protected boolean contains(Body body) {
        double d = this.getCenter().distanceSq(body.getCM());
        return d < this.getRadius() * this.getRadius();
    }

    public Point2D getNewMoleculeLocation() {
        double d = this.random.nextDouble() - (double)GasMolecule.s_radius;
        double d2 = this.random.nextDouble() * Math.PI * 2.0;
        Point2D.Double double_ = new Point2D.Double(this.getPosition().getX() + d * Math.cos(d2), this.getPosition().getY() + d * Math.sin(d2));
        return double_;
    }

    public MutableVector2D getNewMoleculeVelocity(Class clazz, IdealGasModel idealGasModel) {
        double d = 0.0;
        if (clazz == HeavySpecies.class && (d = idealGasModel.getHeavySpeciesAveSpeed()) == 0.0) {
            d = Math.sqrt(30000.0 / HeavySpecies.getMoleculeMass());
        }
        if (clazz == LightSpecies.class && (d = idealGasModel.getLightSpeciesAveSpeed()) == 0.0) {
            d = Math.sqrt(30000.0 / LightSpecies.getMoleculeMass());
        }
        double d2 = this.random.nextDouble() * Math.PI * 2.0;
        return new MutableVector2D(d * Math.cos(d2), d * Math.sin(d2));
    }

    public int getHeavySpeciesCnt() {
        return this.getSpeciesCnt(HeavySpecies.class);
    }

    public int getLightSpeciesCnt() {
        return this.getSpeciesCnt(LightSpecies.class);
    }

    private int getSpeciesCnt(Class clazz) {
        int n = 0;
        for (int i = 0; i < this.containedBodies.size(); ++i) {
            Body body = (Body)this.containedBodies.get(i);
            if (!clazz.isInstance(body)) continue;
            ++n;
        }
        return n;
    }

    public static interface HollowSphereListener
    extends EventListener {
        public void moleculeAdded(MoleculeEvent var1);

        public void moleculeRemoved(MoleculeEvent var1);
    }

    public class MoleculeEvent
    extends EventObject {
        private GasMolecule molecule;

        public MoleculeEvent(Object object, GasMolecule gasMolecule) {
            super(object);
            this.molecule = gasMolecule;
        }

        public GasMolecule getMolecule() {
            return this.molecule;
        }
    }
}

