/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller;

import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.controller.GasSource;
import edu.colorado.phet.idealgas.controller.IdealGasModule;
import edu.colorado.phet.idealgas.model.HeavySpecies;
import edu.colorado.phet.idealgas.model.LightSpecies;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class PumpSpeciesSelectorPanel
extends GraphicLayerSet {
    private Color backgroundColor = new Color(240, 230, 255);
    private JPanel basePanel = new JPanel();

    public PumpSpeciesSelectorPanel(IdealGasModule idealGasModule) {
        this.basePanel.setPreferredSize(new Dimension(130, 70));
        SelectionPanel selectionPanel = new SelectionPanel(idealGasModule, idealGasModule.getPump());
        this.setTitle(IdealGasResources.getString("IdealGasControlPanel.Pump_Gas"));
        this.basePanel.setBackground(this.backgroundColor);
        PhetGraphic phetGraphic = PhetJComponent.newInstance(idealGasModule.getApparatusPanel(), this.basePanel);
        this.addGraphic(phetGraphic);
        this.addGraphic(selectionPanel);
        selectionPanel.setLocation(10, 0);
    }

    public void setTitle(String string) {
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(0, new Color(40, 20, 255), Color.black), string);
        this.basePanel.setBorder(titledBorder);
    }

    private class SelectionPanel
    extends GraphicLayerSet {
        private IdealGasModule module;
        private GasSource gasSource;
        private JRadioButton heavySpeciesRB;
        private JRadioButton lightSpeciesRB;

        SelectionPanel(IdealGasModule idealGasModule, GasSource gasSource) {
            this.module = idealGasModule;
            this.gasSource = gasSource;
            this.makeRadioButtons();
            PhetGraphic phetGraphic = PhetJComponent.newInstance(idealGasModule.getApparatusPanel(), this.heavySpeciesRB);
            PhetGraphic phetGraphic2 = PhetJComponent.newInstance(idealGasModule.getApparatusPanel(), this.lightSpeciesRB);
            phetGraphic.setLocation(0, 20);
            phetGraphic2.setLocation(0, 40);
            this.addGraphic(phetGraphic);
            this.addGraphic(phetGraphic2);
        }

        private void makeRadioButtons() {
            this.heavySpeciesRB = new JRadioButton(IdealGasResources.getString("Common.Heavy_Species"));
            this.heavySpeciesRB.setForeground(Color.blue);
            this.heavySpeciesRB.setBackground(PumpSpeciesSelectorPanel.this.backgroundColor);
            this.lightSpeciesRB = new JRadioButton(IdealGasResources.getString("Common.Light_Species"));
            this.lightSpeciesRB.setForeground(Color.red);
            this.lightSpeciesRB.setBackground(PumpSpeciesSelectorPanel.this.backgroundColor);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.heavySpeciesRB);
            buttonGroup.add(this.lightSpeciesRB);
            this.heavySpeciesRB.setSelected(true);
            this.heavySpeciesRB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (SelectionPanel.this.heavySpeciesRB.isSelected()) {
                        SelectionPanel.this.gasSource.setCurrentGasSpecies(HeavySpecies.class);
                        SelectionPanel.this.module.setCurrentPumpImage(Color.blue);
                    }
                }
            });
            this.lightSpeciesRB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (SelectionPanel.this.lightSpeciesRB.isSelected()) {
                        SelectionPanel.this.gasSource.setCurrentGasSpecies(LightSpecies.class);
                        SelectionPanel.this.module.setCurrentPumpImage(Color.red);
                    }
                }
            });
        }
    }
}

