/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller;

import edu.colorado.phet.idealgas.controller.GasSource;
import edu.colorado.phet.idealgas.controller.IdealGasModule;
import edu.colorado.phet.idealgas.controller.RigidHollowSphereModule;
import edu.colorado.phet.idealgas.controller.SpeciesSelectionPanel;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.HeavySpecies;
import edu.colorado.phet.idealgas.model.HollowSphere;
import edu.colorado.phet.idealgas.model.LightSpecies;

public class HollowSphereControlPanel
extends SpeciesSelectionPanel
implements HollowSphere.HollowSphereListener {
    private HollowSphere sphere;

    public HollowSphereControlPanel(IdealGasModule idealGasModule, GasSource gasSource, HollowSphere hollowSphere) {
        super(idealGasModule);
        this.sphere = hollowSphere;
    }

    private RigidHollowSphereModule getRhsModule() {
        return (RigidHollowSphereModule)this.getModule();
    }

    protected void createMolecule(Class clazz) {
        this.getRhsModule().addMoleculeToSphere(clazz);
    }

    protected void removeMolecule(Class clazz) {
        this.getRhsModule().removeGasMoleculeFromSphere(clazz);
    }

    protected int getHeavySpeciesCnt() {
        return this.sphere.getHeavySpeciesCnt();
    }

    protected int getLightSpeciesCnt() {
        return this.sphere.getLightSpeciesCnt();
    }

    public void moleculeAdded(HollowSphere.MoleculeEvent moleculeEvent) {
        GasMolecule gasMolecule = moleculeEvent.getMolecule();
        if (gasMolecule instanceof HeavySpecies) {
            this.getHeavySpinner().updateValue();
        } else if (gasMolecule instanceof LightSpecies) {
            this.getLightSpinner().updateValue();
        }
    }

    public void moleculeRemoved(HollowSphere.MoleculeEvent moleculeEvent) {
        GasMolecule gasMolecule = moleculeEvent.getMolecule();
        if (gasMolecule instanceof HeavySpecies) {
            this.getHeavySpinner().updateValue();
        } else if (gasMolecule instanceof LightSpecies) {
            this.getLightSpinner().updateValue();
        }
    }
}

