/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.collision;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.idealgas.collision.CollidableBody;
import edu.colorado.phet.idealgas.collision.NullFixupStrategy;
import edu.colorado.phet.idealgas.collision.SphericalBody;
import edu.colorado.phet.idealgas.collision.WallFixupStrategy;
import edu.colorado.phet.idealgas.coreadditions.Translatable;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EventListener;
import java.util.EventObject;

public class Wall
extends CollidableBody
implements Translatable {
    private MutableVector2D velocity = new MutableVector2D();
    private Rectangle2D rep = new Rectangle2D.Double();
    private Rectangle2D movementBounds;
    private Rectangle2D prevRep = new Rectangle2D.Double();
    private double minimumWallThickness;
    private WallFixupStrategy fixupStrategy = new NullFixupStrategy();
    private EventChannel changeEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeEventChannel.getListenerProxy();

    public Wall(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        this.rep = rectangle2D;
        this.movementBounds = rectangle2D2;
        this.setMass(Double.POSITIVE_INFINITY);
        this.setPosition(rectangle2D.getMinX(), rectangle2D.getMinY());
    }

    public void stepInTime(double d) {
    }

    public void setPosition(double d, double d2) {
        d = Math.min(d, this.movementBounds.getMaxX() - this.rep.getWidth());
        d = Math.max(d, this.movementBounds.getMinX());
        d2 = Math.min(d2, this.movementBounds.getMaxY() - this.rep.getHeight());
        d2 = Math.max(d2, this.movementBounds.getMinY());
        super.setPosition(d, d2);
        this.prevRep.setRect(this.rep);
        this.rep.setRect(d, d2, this.rep.getWidth(), this.rep.getHeight());
        this.changeListenerProxy.wallChanged(new ChangeEvent(this));
    }

    public void setPosition(Point2D point2D) {
        this.setPosition(point2D.getX(), point2D.getY());
    }

    public void setBounds(Rectangle2D rectangle2D) {
        if (rectangle2D.getWidth() < this.minimumWallThickness) {
            return;
        }
        double d = Math.max(Math.min(rectangle2D.getMinX(), this.movementBounds.getMaxX()), this.movementBounds.getMinX());
        double d2 = Math.max(Math.min(rectangle2D.getMinY(), this.movementBounds.getMaxY()), this.movementBounds.getMinY());
        double d3 = Math.min(Math.max(rectangle2D.getMaxX(), this.movementBounds.getMinX()), this.movementBounds.getMaxX());
        double d4 = Math.min(Math.max(rectangle2D.getMaxY(), this.movementBounds.getMinY()), this.movementBounds.getMaxY());
        this.rep.setRect(d, d2, d3 - d, d4 - d2);
        this.setPosition(d, d2);
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(this.rep.getX(), this.rep.getY(), this.rep.getWidth(), this.rep.getHeight());
    }

    public void setMovementBounds(Rectangle2D rectangle2D) {
        this.movementBounds = rectangle2D;
        this.changeListenerProxy.wallChanged(new ChangeEvent(this));
    }

    public Point2D getPositionPrev() {
        return null;
    }

    public Point2D getCM() {
        return new Point2D.Double(this.rep.getMinX() + this.rep.getWidth() / 2.0, this.rep.getMinY() + this.rep.getHeight() / 2.0);
    }

    public double getMomentOfInertia() {
        return Double.POSITIVE_INFINITY;
    }

    public double getKineticEnergy() {
        return 0.0;
    }

    public void translate(double d, double d2) {
        super.translate(d, d2);
    }

    public void setFixupStrategy(WallFixupStrategy wallFixupStrategy) {
        this.fixupStrategy = wallFixupStrategy;
    }

    public void fixup(SphericalBody sphericalBody) {
        this.fixupStrategy.fixup(this, sphericalBody);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.addListener(changeListener);
    }

    public void setMinimumWidth(double d) {
        this.minimumWallThickness = d;
    }

    public class ChangeEvent
    extends EventObject {
        public ChangeEvent(Object object) {
            super(object);
        }

        public Wall getWall() {
            return (Wall)this.getSource();
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void wallChanged(ChangeEvent var1);
    }
}

