/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.view.manager;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.hydrogenatom.model.Model;
import edu.umd.cs.piccolo.PNode;
import java.util.ArrayList;
import java.util.HashMap;

public class ModelViewManager
implements Model.ModelListener {
    private Model _model;
    private HashMap<Class, ArrayList<NodeFactory>> _factoriesMap;
    private HashMap<ModelElement, ArrayList<NodeRecord>> _nodeRecordsMap;

    public ModelViewManager(Model model) {
        this._model = model;
        this._model.addModelListener(this);
        this._factoriesMap = new HashMap();
        this._nodeRecordsMap = new HashMap();
    }

    public void addNodeFactory(NodeFactory nodeFactory) {
        Class clazz = nodeFactory.getModelElementClass();
        ArrayList<NodeFactory> arrayList = this._factoriesMap.get(clazz);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this._factoriesMap.put(clazz, arrayList);
        }
        arrayList.add(nodeFactory);
    }

    public void modelElementAdded(ModelElement modelElement) {
        Class<?> clazz = modelElement.getClass();
        ArrayList<NodeFactory> arrayList = this._factoriesMap.get(clazz);
        if (arrayList != null) {
            ArrayList<NodeRecord> arrayList2 = null;
            for (NodeFactory nodeFactory : new ArrayList<NodeFactory>(arrayList)) {
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<NodeRecord>();
                }
                PNode pNode = nodeFactory.createNode(modelElement);
                PNode pNode2 = nodeFactory.getParent();
                pNode2.addChild(pNode);
                arrayList2.add(new NodeRecord(pNode, pNode2));
            }
            if (arrayList2 != null) {
                this._nodeRecordsMap.put(modelElement, arrayList2);
            }
        }
    }

    public void modelElementRemoved(ModelElement modelElement) {
        ArrayList<NodeRecord> arrayList = this._nodeRecordsMap.get(modelElement);
        if (arrayList != null) {
            for (NodeRecord nodeRecord : new ArrayList<NodeRecord>(arrayList)) {
                PNode pNode = nodeRecord.getNode();
                PNode pNode2 = nodeRecord.getParent();
                pNode2.removeChild(pNode);
            }
            this._nodeRecordsMap.remove(modelElement);
        }
    }

    public static abstract class NodeFactory {
        private Class _modelElementClass;
        private PNode _parent;

        protected NodeFactory(Class clazz, PNode pNode) {
            this._modelElementClass = clazz;
            this._parent = pNode;
        }

        public Class getModelElementClass() {
            return this._modelElementClass;
        }

        public PNode getParent() {
            return this._parent;
        }

        public abstract PNode createNode(ModelElement var1);
    }

    private static class NodeRecord {
        private PNode _node;
        private PNode _parent;

        public NodeRecord(PNode pNode, PNode pNode2) {
            this._node = pNode;
            this._parent = pNode2;
        }

        public PNode getNode() {
            return this._node;
        }

        public PNode getParent() {
            return this._parent;
        }
    }
}

