/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.view.atom;

import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.TextButtonNode;
import edu.colorado.phet.hydrogenatom.HAConstants;
import edu.colorado.phet.hydrogenatom.HAResources;
import edu.colorado.phet.hydrogenatom.hacks.MetastableHandler;
import edu.colorado.phet.hydrogenatom.model.SchrodingerModel;
import edu.colorado.phet.hydrogenatom.view.atom.AbstractHydrogenAtomNode;
import edu.colorado.phet.hydrogenatom.view.atom.StateDisplayNode;
import edu.colorado.phet.hydrogenatom.view.particle.ElectronNode;
import edu.colorado.phet.hydrogenatom.view.particle.ProtonNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Observable;
import java.util.Observer;

public class SchrodingerNode
extends AbstractHydrogenAtomNode
implements MetastableHandler.MetastableListener,
Observer {
    private static final double BOX_WIDTH = HAConstants.ANIMATION_BOX_SIZE.getWidth();
    private static final double BOX_HEIGHT = HAConstants.ANIMATION_BOX_SIZE.getHeight();
    private static final double CELL_WIDTH = HAConstants.ANIMATION_BOX_SIZE.getWidth() / 40.0 / 2.0;
    private static final double CELL_HEIGHT = HAConstants.ANIMATION_BOX_SIZE.getHeight() / 40.0 / 2.0;
    private static final double CELL_DEPTH = HAConstants.ANIMATION_BOX_SIZE.getHeight() / 40.0 / 2.0;
    private static final Color MAX_COLOR = ElectronNode.getColor();
    private static final Color MIN_COLOR = Color.BLACK;
    private static BrightnessCache BRIGHTNESS_CACHE;
    private SchrodingerModel _atom;
    private StateDisplayNode _stateDisplayNode;
    private AtomNode _fieldNode;
    private ProtonNode _protonNode;
    private TextButtonNode _exciteButton;

    public SchrodingerNode(SchrodingerModel schrodingerModel) {
        this.setChildrenPickable(true);
        assert (SchrodingerModel.getGroundState() == 1);
        if (BRIGHTNESS_CACHE == null) {
            BRIGHTNESS_CACHE = new BrightnessCache(false);
        }
        this._atom = schrodingerModel;
        this._atom.addObserver(this);
        this._atom.addMetastableListener(this);
        this._fieldNode = new AtomNode();
        this._protonNode = new ProtonNode();
        this._protonNode.setOffset(BOX_WIDTH / 2.0, BOX_HEIGHT / 2.0);
        Axes2DNode axes2DNode = new Axes2DNode("x", "z");
        double d = 20.0;
        double d2 = BOX_HEIGHT - axes2DNode.getHeight() - 20.0;
        axes2DNode.setOffset(d, d2);
        this._stateDisplayNode = new StateDisplayNode();
        this._stateDisplayNode.setVisible(true);
        this._stateDisplayNode.setState(6, 5, -5);
        d = BOX_WIDTH - this._stateDisplayNode.getFullBounds().getWidth() - 15.0;
        d2 = BOX_HEIGHT - this._stateDisplayNode.getFullBounds().getHeight() - 15.0;
        this._stateDisplayNode.setOffset(d, d2);
        this._exciteButton = new TextButtonNode(HAResources.getString("button.excite"), new PhetFont(18), Color.YELLOW);
        this._exciteButton.setVisible(false);
        d = this._stateDisplayNode.getFullBoundsReference().getMaxX() - this._exciteButton.getFullBoundsReference().getWidth() - 5.0;
        d2 = this._stateDisplayNode.getFullBoundsReference().getMinY() - this._exciteButton.getFullBoundsReference().getHeight() - 10.0;
        this._exciteButton.setOffset(d, d2);
        this._exciteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SchrodingerNode.this._atom.fireOneAbsorbablePhoton();
            }
        });
        this.addChild(this._fieldNode);
        this.addChild(this._protonNode);
        this.addChild(axes2DNode);
        this.addChild(this._exciteButton);
        if (this._stateDisplayNode != null) {
            this.addChild(this._stateDisplayNode);
        }
        this.setOffset(0.0, 0.0);
        this.update(this._atom, "electronState");
    }

    public void update(Observable observable, Object object) {
        if (observable == this._atom) {
            if (object == "electronState") {
                this.handleStateChange();
            } else if (object == "atomIonized") {
                // empty if block
            }
        }
    }

    public void enteredMetastableState() {
        if (this._atom.isMonochromaticLightType()) {
            this._exciteButton.setVisible(true);
        }
    }

    public void exitedMetastableState() {
        this._exciteButton.setVisible(false);
    }

    public void handleStateChange() {
        int n = this._atom.getElectronState();
        int n2 = this._atom.getSecondaryElectronState();
        int n3 = Math.abs(this._atom.getTertiaryElectronState());
        if (this._stateDisplayNode != null) {
            this._stateDisplayNode.setState(n, n2, n3);
        }
        float[][] fArray = BRIGHTNESS_CACHE.getBrightness(n, n2, n3);
        this._fieldNode.setBrightness(fArray);
    }

    private static class AtomNode
    extends PNode {
        private GridNode _gridNode;
        private PImage _upperLeftNode;
        private PImage _upperRightNode;
        private PImage _lowerLeftNode;
        private PImage _lowerRightNode;
        private BufferedImage _bufferedImage;

        public AtomNode() {
            this.setPickable(false);
            this.setChildrenPickable(false);
            this._gridNode = new GridNode(BOX_WIDTH / 2.0, BOX_HEIGHT / 2.0);
            this._bufferedImage = new BufferedImage((int)this._gridNode.getWidth(), (int)this._gridNode.getHeight(), 3);
            this._upperLeftNode = new PImage();
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(BOX_WIDTH / 2.0 + 0.5, BOX_HEIGHT / 2.0 + 0.5);
            affineTransform.scale(-1.0, -1.0);
            this._upperLeftNode.setTransform(affineTransform);
            this.addChild(this._upperLeftNode);
            this._upperRightNode = new PImage();
            AffineTransform affineTransform2 = new AffineTransform();
            affineTransform2.translate(BOX_WIDTH / 2.0 - 0.5, BOX_HEIGHT / 2.0 + 0.5);
            affineTransform2.scale(1.0, -1.0);
            this._upperRightNode.setTransform(affineTransform2);
            this.addChild(this._upperRightNode);
            this._lowerRightNode = new PImage();
            AffineTransform affineTransform3 = new AffineTransform();
            affineTransform3.translate(BOX_WIDTH / 2.0 - 0.5, BOX_HEIGHT / 2.0 - 0.5);
            affineTransform3.scale(1.0, 1.0);
            this._lowerRightNode.setTransform(affineTransform3);
            this.addChild(this._lowerRightNode);
            this._lowerLeftNode = new PImage();
            AffineTransform affineTransform4 = new AffineTransform();
            affineTransform4.translate(BOX_WIDTH / 2.0 + 0.5, BOX_HEIGHT / 2.0 - 0.5);
            affineTransform4.scale(-1.0, 1.0);
            this._lowerLeftNode.setTransform(affineTransform4);
            this.addChild(this._lowerLeftNode);
        }

        public void setBrightness(float[][] fArray) {
            this._gridNode.setBrightness(fArray);
            Image image = this._gridNode.toImage(this._bufferedImage, null);
            this._upperLeftNode.setImage(image);
            this._upperRightNode.setImage(image);
            this._lowerLeftNode.setImage(image);
            this._lowerRightNode.setImage(image);
        }
    }

    private static class Axes2DNode
    extends PNode {
        private static final Color AXIS_COLOR = Color.WHITE;
        private static final Font LABEL_FONT = new PhetFont(0, 14);
        private static final Color LABEL_COLOR = Color.WHITE;

        public Axes2DNode(String string, String string2) {
            this.setPickable(false);
            this.setChildrenPickable(false);
            Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
            Point2D.Double double_2 = new Point2D.Double(100.0, 0.0);
            ArrowNode arrowNode = new ArrowNode(double_, double_2, 10.0, 10.0, 1.0);
            arrowNode.setPaint(AXIS_COLOR);
            arrowNode.setStroke(null);
            Point2D.Double double_3 = new Point2D.Double(0.0, -100.0);
            ArrowNode arrowNode2 = new ArrowNode(double_, double_3, 10.0, 10.0, 1.0);
            arrowNode2.setPaint(AXIS_COLOR);
            arrowNode2.setStroke(null);
            PText pText = new PText(string);
            pText.setFont(LABEL_FONT);
            pText.setTextPaint(LABEL_COLOR);
            PText pText2 = new PText(string2);
            pText2.setFont(LABEL_FONT);
            pText2.setTextPaint(LABEL_COLOR);
            pText.setOffset(arrowNode.getWidth() + 5.0, -pText.getHeight() / 2.0);
            pText2.setOffset(-pText2.getWidth() / 2.0, -(arrowNode2.getHeight() + 5.0 + pText2.getHeight()));
            this.addChild(arrowNode);
            this.addChild(arrowNode2);
            this.addChild(pText);
            this.addChild(pText2);
        }
    }

    private static final class BrightnessCache {
        private float[][][][][] _cache;
        float[][] _sums = new float[40][40];

        public BrightnessCache(boolean bl) {
            int n = 0;
            int n2 = SchrodingerModel.getNumberOfStates();
            this._cache = new float[n2][][][][];
            for (int i = 1; i <= n2; ++i) {
                int n3 = i;
                this._cache[i - 1] = new float[n3][][][];
                for (int j = 0; j < n3; ++j) {
                    int n4 = j + 1;
                    this._cache[i - 1][j] = new float[n4][][];
                    for (int k = 0; k < n4; ++k) {
                        ++n;
                        if (!bl) continue;
                        this.getBrightness(i, j, k);
                    }
                }
            }
        }

        public float[][] getBrightness(int n, int n2, int n3) {
            float[][] fArray = this._cache[n - 1][n2][n3];
            if (fArray == null) {
                fArray = BrightnessCache.computeBrightness(n, n2, n3, this._sums);
                this._cache[n - 1][n2][n3] = fArray;
            }
            return fArray;
        }

        private static final float[][] computeBrightness(int n, int n2, int n3, float[][] fArray) {
            int n4;
            float[][] fArray2 = new float[40][40];
            float f = 0.0f;
            for (n4 = 0; n4 < 40; ++n4) {
                double d = (double)n4 * CELL_HEIGHT + CELL_HEIGHT / 2.0;
                assert (d > 0.0);
                for (int i = 0; i < 40; ++i) {
                    double d2 = (double)i * CELL_WIDTH + CELL_WIDTH / 2.0;
                    assert (d2 > 0.0);
                    float f2 = 0.0f;
                    for (int j = 0; j < 40; ++j) {
                        double d3 = (double)j * CELL_DEPTH + CELL_DEPTH / 2.0;
                        assert (d3 > 0.0);
                        double d4 = SchrodingerModel.getProbabilityDensity(n, n2, n3, d2, d3, d);
                        f2 = (float)((double)f2 + d4);
                    }
                    fArray[n4][i] = f2;
                    if (!(f2 > f)) continue;
                    f = f2;
                }
            }
            for (n4 = 0; n4 < 40; ++n4) {
                for (int i = 0; i < 40; ++i) {
                    float f3 = 0.0f;
                    if (f > 0.0f) {
                        f3 = fArray[n4][i] / f;
                    }
                    fArray2[n4][i] = f3;
                }
            }
            return fArray2;
        }
    }

    private static class GridNode
    extends PNode {
        private float[][] _brightness;
        private double _cellWidth;
        private double _cellHeight;
        private Rectangle2D _rectangle;

        public GridNode(double d, double d2) {
            this.setPickable(false);
            this.setChildrenPickable(false);
            this.setBounds(0.0, 0.0, d, d2);
            this._rectangle = new Rectangle2D.Double();
        }

        public void setBrightness(float[][] fArray) {
            this._brightness = fArray;
            this._cellHeight = this.getHeight() / (double)fArray.length;
            this._cellWidth = this.getWidth() / (double)fArray[0].length;
            this.repaint();
        }

        protected void paint(PPaintContext pPaintContext) {
            if (this._brightness == null) {
                return;
            }
            Graphics2D graphics2D = pPaintContext.getGraphics();
            Color color = graphics2D.getColor();
            double d = this._cellWidth + 0.1 * this._cellWidth;
            double d2 = this._cellHeight + 0.1 * this._cellHeight;
            for (int i = 0; i < this._brightness.length; ++i) {
                for (int j = 0; j < this._brightness[i].length; ++j) {
                    Color color2 = ColorUtils.interpolateRBGA(MIN_COLOR, MAX_COLOR, this._brightness[i][j]);
                    graphics2D.setColor(color2);
                    double d3 = (double)j * this._cellWidth;
                    double d4 = (double)i * this._cellHeight;
                    this._rectangle.setRect(d3, d4, d, d2);
                    graphics2D.fill(this._rectangle);
                }
            }
            graphics2D.setColor(color);
        }
    }
}

