/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.view.atom;

import edu.colorado.phet.hydrogenatom.model.DeBroglieModel;
import edu.colorado.phet.hydrogenatom.view.HAModelViewTransform;
import edu.colorado.phet.hydrogenatom.view.atom.DeBroglieNode;
import edu.colorado.phet.hydrogenatom.view.particle.ElectronNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;

public class DeBroglieRadialDistanceNode
extends DeBroglieNode.AbstractDeBroglie2DViewStrategy {
    private static final Color COLOR = ElectronNode.getColor();
    private static final Stroke STROKE = new BasicStroke(2.0f);
    private PPath _ringNode;
    private GeneralPath _ringPath = new GeneralPath();

    public DeBroglieRadialDistanceNode(DeBroglieModel deBroglieModel) {
        super(deBroglieModel);
        this._ringNode = new PPath();
        this._ringNode.setStrokePaint(COLOR);
        this._ringNode.setStroke(STROKE);
        this.addChild(this._ringNode);
        this.update();
    }

    public void update() {
        this._ringPath.reset();
        DeBroglieModel deBroglieModel = this.getAtom();
        double d = HAModelViewTransform.transform(this.getAtom().getElectronOrbitRadius());
        this.getAtom();
        double d2 = HAModelViewTransform.transform(DeBroglieModel.getOrbitRadius(DeBroglieModel.getGroundState()));
        for (int i = 0; i < 200; ++i) {
            double d3 = Math.PI * 2 * ((double)i / 200.0);
            double d4 = deBroglieModel.getAmplitude(d3);
            double d5 = 0.45 * d2;
            double d6 = d5 * d4;
            float f = (float)((d + d6) * Math.cos(d3));
            float f2 = (float)((d + d6) * Math.sin(d3));
            if (i == 0) {
                this._ringPath.moveTo(f, f2);
                continue;
            }
            this._ringPath.lineTo(f, f2);
        }
        this._ringPath.closePath();
        this._ringNode.setPathTo(this._ringPath);
    }
}

