/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.view.atom;

import edu.colorado.phet.hydrogenatom.model.DeBroglieModel;
import edu.colorado.phet.hydrogenatom.view.HAModelViewTransform;
import edu.colorado.phet.hydrogenatom.view.atom.DeBroglieNode;
import edu.colorado.phet.hydrogenatom.view.atom.OrbitNodeFactory;
import edu.colorado.phet.hydrogenatom.view.particle.ElectronNode;
import edu.colorado.phet.hydrogenatom.view.particle.ProtonNode;
import edu.colorado.phet.hydrogenatom.wireframe.Matrix3D;
import edu.colorado.phet.hydrogenatom.wireframe.Vertex3D;
import edu.colorado.phet.hydrogenatom.wireframe.Wireframe3D;
import edu.colorado.phet.hydrogenatom.wireframe.Wireframe3DNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;

public class DeBroglieHeight3DNode
extends DeBroglieNode.AbstractDeBroglieViewStrategy {
    private static final Color ORBIT_FRONT_COLOR = OrbitNodeFactory.getOrbitColor();
    private static final Color ORBIT_BACK_COLOR = ORBIT_FRONT_COLOR.darker().darker().darker();
    private static final Color WAVE_FRONT_COLOR = ElectronNode.getColor();
    private static final Color WAVE_BACK_COLOR = WAVE_FRONT_COLOR.darker().darker().darker();
    private PNode _staticNode;
    private Wireframe3DNode _waveNode;
    private Matrix3D _viewMatrix = new Matrix3D();
    private double _currentViewAngle = 0.0;
    private boolean _finalViewAngleDrawn = false;
    private Vertex3D[] _orbitVerticies;
    private Vertex3D[] _waveVerticies;
    private Wireframe3D _waveWireframe;

    public DeBroglieHeight3DNode(DeBroglieModel deBroglieModel) {
        super(deBroglieModel);
        int n;
        this._viewMatrix.xrot(this._currentViewAngle);
        this._orbitVerticies = new Vertex3D[200];
        for (n = 0; n < this._orbitVerticies.length; ++n) {
            this._orbitVerticies[n] = new Vertex3D();
        }
        this._waveVerticies = new Vertex3D[200];
        for (n = 0; n < this._waveVerticies.length; ++n) {
            this._waveVerticies[n] = new Vertex3D();
        }
        this._waveWireframe = new Wireframe3D();
        this._waveWireframe.setColors(WAVE_FRONT_COLOR, WAVE_BACK_COLOR);
        this._waveWireframe.setStrokeWidth(2.0f);
        this._staticNode = new PNode();
        this.addChild(this._staticNode);
        this._waveNode = new Wireframe3DNode(this._waveWireframe);
        this.addChild(this._waveNode);
        this.update();
    }

    public void update() {
        this.updateWaveNode();
        if (!this._finalViewAngleDrawn) {
            this.updateStaticNode();
            this.updateViewMatrix();
        }
    }

    private void updateStaticNode() {
        this._staticNode.removeAllChildren();
        this.getAtom();
        int n = DeBroglieModel.getGroundState();
        this.getAtom();
        int n2 = DeBroglieModel.getNumberOfStates();
        for (int i = n; i < n + n2; ++i) {
            this.getAtom();
            double d = HAModelViewTransform.transform(DeBroglieModel.getOrbitRadius(i));
            Wireframe3DNode wireframe3DNode = DeBroglieHeight3DNode.create3DOrbitNode(d, this._viewMatrix, this._orbitVerticies);
            this._staticNode.addChild(wireframe3DNode);
        }
        ProtonNode protonNode = new ProtonNode();
        protonNode.setOffset(0.0, 0.0);
        this._staticNode.addChild(protonNode);
    }

    private void updateWaveNode() {
        DeBroglieHeight3DNode.getWaveVerticies(this.getAtom(), this._waveVerticies);
        this._waveWireframe.reset();
        this._waveWireframe.addVerticies(this._waveVerticies);
        for (int i = 0; i < this._waveVerticies.length - 1; ++i) {
            this._waveWireframe.addLine(i, i + 1);
        }
        this._waveWireframe.addLine(this._waveVerticies.length - 1, 0);
        Matrix3D matrix3D = this._waveWireframe.getMatrix();
        matrix3D.unit();
        float f = -(this._waveWireframe.getXMin() + this._waveWireframe.getXMax()) / 2.0f;
        float f2 = -(this._waveWireframe.getYMin() + this._waveWireframe.getYMax()) / 2.0f;
        float f3 = -(this._waveWireframe.getZMin() + this._waveWireframe.getZMax()) / 2.0f;
        matrix3D.translate(f, f2, f3);
        matrix3D.mult(this._viewMatrix);
        this._waveWireframe.setMatrix(matrix3D);
    }

    private void updateViewMatrix() {
        if (this._currentViewAngle == 70.0) {
            this._finalViewAngleDrawn = true;
        } else {
            this._currentViewAngle += 5.0;
            if (this._currentViewAngle > 70.0) {
                this._currentViewAngle = 70.0;
            }
            this._viewMatrix.unit();
            this._viewMatrix.xrot(this._currentViewAngle);
        }
    }

    private static Wireframe3DNode create3DOrbitNode(double d, Matrix3D matrix3D, Vertex3D[] vertex3DArray) {
        DeBroglieHeight3DNode.getOrbitVerticies(d, vertex3DArray);
        Wireframe3D wireframe3D = new Wireframe3D(vertex3DArray);
        for (int i = 0; i < vertex3DArray.length - 1; i += 2) {
            wireframe3D.addLine(i, i + 1);
        }
        wireframe3D.setColors(ORBIT_FRONT_COLOR, ORBIT_BACK_COLOR);
        wireframe3D.setStrokeWidth(1.0f);
        Matrix3D matrix3D2 = wireframe3D.getMatrix();
        matrix3D2.unit();
        float f = -(wireframe3D.getXMin() + wireframe3D.getXMax()) / 2.0f;
        float f2 = -(wireframe3D.getYMin() + wireframe3D.getYMax()) / 2.0f;
        float f3 = -(wireframe3D.getZMin() + wireframe3D.getZMax()) / 2.0f;
        matrix3D2.translate(f, f2, f3);
        matrix3D2.mult(matrix3D);
        wireframe3D.setMatrix(matrix3D2);
        return new Wireframe3DNode(wireframe3D);
    }

    private static Vertex3D[] getWaveVerticies(DeBroglieModel deBroglieModel, Vertex3D[] vertex3DArray) {
        int n = vertex3DArray.length;
        double d = Math.PI * 2 / (double)n;
        double d2 = HAModelViewTransform.transform(deBroglieModel.getElectronOrbitRadius());
        for (int i = 0; i < n; ++i) {
            double d3 = (double)i * d;
            double d4 = d2 * Math.cos(d3);
            double d5 = d2 * Math.sin(d3);
            double d6 = 15.0 * deBroglieModel.getAmplitude(d3);
            vertex3DArray[i].setLocation((float)d4, (float)d5, (float)d6);
        }
        return vertex3DArray;
    }

    private static Vertex3D[] getOrbitVerticies(double d, Vertex3D[] vertex3DArray) {
        int n = vertex3DArray.length;
        double d2 = Math.PI * 2 / (double)n;
        for (int i = 0; i < n; ++i) {
            double d3 = (double)i * d2;
            double d4 = d * Math.cos(d3);
            double d5 = d * Math.sin(d3);
            double d6 = 0.0;
            vertex3DArray[i].setLocation((float)d4, (float)d5, (float)d6);
        }
        return vertex3DArray;
    }
}

