/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.view.atom;

import edu.colorado.phet.hydrogenatom.HAConstants;
import edu.colorado.phet.hydrogenatom.model.BohrModel;
import edu.colorado.phet.hydrogenatom.view.HAModelViewTransform;
import edu.colorado.phet.hydrogenatom.view.OriginNode;
import edu.colorado.phet.hydrogenatom.view.atom.AbstractHydrogenAtomNode;
import edu.colorado.phet.hydrogenatom.view.atom.OrbitNodeFactory;
import edu.colorado.phet.hydrogenatom.view.atom.StateDisplayNode;
import edu.colorado.phet.hydrogenatom.view.particle.ElectronNode;
import edu.colorado.phet.hydrogenatom.view.particle.ProtonNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;

public class BohrNode
extends AbstractHydrogenAtomNode
implements Observer {
    private ArrayList _orbitNodes;
    private ProtonNode _protonNode;
    private ElectronNode _electronNode;
    private StateDisplayNode _stateNode;
    private BohrModel _atom;

    public BohrNode(BohrModel bohrModel) {
        this._atom = bohrModel;
        this._atom.addObserver(this);
        this._orbitNodes = new ArrayList();
        int n = BohrModel.getGroundState();
        int n2 = BohrModel.getNumberOfStates();
        for (int i = n; i < n + n2; ++i) {
            double d = HAModelViewTransform.transform(BohrModel.getOrbitRadius(i));
            PPath pPath = OrbitNodeFactory.createOrbitNode(d);
            this.addChild(pPath);
            this._orbitNodes.add(pPath);
        }
        this._protonNode = new ProtonNode();
        this.addChild(this._protonNode);
        this._electronNode = new ElectronNode();
        this.addChild(this._electronNode);
        this._stateNode = new StateDisplayNode();
        this._stateNode.setState(bohrModel.getElectronState());
        this.addChild(this._stateNode);
        double d = HAConstants.ANIMATION_BOX_SIZE.getWidth() / 2.0 - this._stateNode.getFullBounds().getWidth() - 15.0;
        double d2 = HAConstants.ANIMATION_BOX_SIZE.getHeight() / 2.0 - this._stateNode.getFullBounds().getHeight() - 15.0;
        this._stateNode.setOffset(d, d2);
        OriginNode originNode = new OriginNode(Color.GREEN);
        Point2D point2D = this._atom.getPositionRef();
        Point2D point2D2 = HAModelViewTransform.transform(point2D);
        this.setOffset(point2D2);
        this._protonNode.setOffset(0.0, 0.0);
        this.update(this._atom, "electronOffset");
    }

    public void update(Observable observable, Object object) {
        if (observable == this._atom) {
            if (object == "electronOffset") {
                Point2D point2D = this._atom.getElectronOffsetRef();
                double d = HAModelViewTransform.transform(point2D.getX());
                double d2 = HAModelViewTransform.transform(point2D.getY());
                this._electronNode.setOffset(d, d2);
            }
            if (object == "electronState") {
                if (this._stateNode != null) {
                    this._stateNode.setState(this._atom.getElectronState());
                }
            } else if (object == "atomIonized") {
                // empty if block
            }
        }
    }
}

