/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.module;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.help.DefaultWiggleMe;
import edu.colorado.phet.common.piccolophet.help.MotionHelpBalloon;
import edu.colorado.phet.hydrogenatom.HAConstants;
import edu.colorado.phet.hydrogenatom.HADefaults;
import edu.colorado.phet.hydrogenatom.HAResources;
import edu.colorado.phet.hydrogenatom.control.AtomicModelSelector;
import edu.colorado.phet.hydrogenatom.control.DeBroglieViewControl;
import edu.colorado.phet.hydrogenatom.control.GunControlPanel;
import edu.colorado.phet.hydrogenatom.control.HAClockControlPanel;
import edu.colorado.phet.hydrogenatom.control.ModeSwitch;
import edu.colorado.phet.hydrogenatom.energydiagrams.BohrEnergyDiagram;
import edu.colorado.phet.hydrogenatom.energydiagrams.DeBroglieEnergyDiagram;
import edu.colorado.phet.hydrogenatom.energydiagrams.SchrodingerEnergyDiagram;
import edu.colorado.phet.hydrogenatom.energydiagrams.SolarSystemEnergyDiagram;
import edu.colorado.phet.hydrogenatom.enums.AtomicModel;
import edu.colorado.phet.hydrogenatom.enums.DeBroglieView;
import edu.colorado.phet.hydrogenatom.model.AbstractHydrogenAtom;
import edu.colorado.phet.hydrogenatom.model.BilliardBallModel;
import edu.colorado.phet.hydrogenatom.model.BohrModel;
import edu.colorado.phet.hydrogenatom.model.DeBroglieModel;
import edu.colorado.phet.hydrogenatom.model.ExperimentModel;
import edu.colorado.phet.hydrogenatom.model.Gun;
import edu.colorado.phet.hydrogenatom.model.HAClock;
import edu.colorado.phet.hydrogenatom.model.HAModel;
import edu.colorado.phet.hydrogenatom.model.PlumPuddingModel;
import edu.colorado.phet.hydrogenatom.model.SchrodingerModel;
import edu.colorado.phet.hydrogenatom.model.SolarSystemModel;
import edu.colorado.phet.hydrogenatom.model.Space;
import edu.colorado.phet.hydrogenatom.view.AnimationBoxNode;
import edu.colorado.phet.hydrogenatom.view.BeamNode;
import edu.colorado.phet.hydrogenatom.view.BoxOfHydrogenNode;
import edu.colorado.phet.hydrogenatom.view.GunNode;
import edu.colorado.phet.hydrogenatom.view.LegendPanel;
import edu.colorado.phet.hydrogenatom.view.NotToScaleNode;
import edu.colorado.phet.hydrogenatom.view.SpectrometerNode;
import edu.colorado.phet.hydrogenatom.view.TracesNode;
import edu.colorado.phet.hydrogenatom.view.ZoomIndicatorNode;
import edu.colorado.phet.hydrogenatom.view.manager.HAModelViewManager;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PComboBox;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HAModule
extends PiccoloModule {
    private PhetPCanvas _canvas;
    private PNode _rootNode;
    private HAClockControlPanel _clockControlPanel;
    private ModeSwitch _modeSwitch;
    private AtomicModelSelector _atomicModelSelector;
    private GunControlPanel _gunControlPanel;
    private PSwing _deBroglieViewControlWrapper;
    private PNode _boxBeamGunParent;
    private BoxOfHydrogenNode _boxOfHydrogenNode;
    private BeamNode _beamNode;
    private GunNode _gunNode;
    private AnimationBoxNode _animationBoxNode;
    private ZoomIndicatorNode _zoomIndicatorNode;
    private TracesNode _alphaParticleTracesNode;
    private JCheckBox _spectrometerCheckBox;
    private PSwing _spectrometerCheckBoxNode;
    private SpectrometerNode _spectrometerNode;
    private ArrayList<SpectrometerNode.SpectrometerSnapshotNode> _spectrometerSnapshotNodes;
    private int _spectrometerSnapshotsCounter;
    private JCheckBox _energyDiagramCheckBox;
    private PSwing _energyDiagramCheckBoxNode;
    private PhetPNode _energyDiagramParent;
    private SolarSystemEnergyDiagram _solarSystemEnergyDiagram;
    private BohrEnergyDiagram _bohrEnergyDiagram;
    private DeBroglieEnergyDiagram _deBroglieEnergyDiagram;
    private SchrodingerEnergyDiagram _schrodingerEnergyDiagram;
    private NotToScaleNode _notToScaleLabel;
    private LegendPanel.LegendNode _legendNode;
    private Font _spectrometerFont;
    private HAModel _model;
    private DefaultWiggleMe _wiggleMe;
    private boolean _wiggleMeInitialized = false;
    private HAModelViewManager _modelViewManager;

    public HAModule() {
        super(HAResources.getString("HAModule.title"), new HAClock(), false);
        this.setLogoPanel(null);
        int n = HAResources.getInt("jcomponent.font.size", 16);
        PhetFont phetFont = new PhetFont(1, n);
        int n2 = HAResources.getInt("spectrometer.font.size", 16);
        this._spectrometerFont = new PhetFont(1, n2);
        HAClock hAClock = (HAClock)this.getClock();
        Object object = new Point2D.Double(0.0, 0.0);
        double d = Math.toRadians(-90.0);
        double d2 = HAConstants.ANIMATION_BOX_SIZE.width;
        Gun gun = new Gun((Point2D)object, d, d2, 92.0, 780.0);
        double d3 = gun.getNozzleWidth();
        double d4 = HAConstants.ANIMATION_BOX_SIZE.height;
        Rectangle2D.Double double_ = new Rectangle2D.Double(-d3 / 2.0, -d4, d3, d4);
        Space space = new Space(double_);
        this._model = new HAModel(hAClock, gun, space);
        this._canvas = new PhetPCanvas(HAConstants.CANVAS_RENDERING_SIZE);
        this._canvas.setBackground(HAConstants.CANVAS_BACKGROUND);
        this.setSimulationPanel(this._canvas);
        this._canvas.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                HAModule.this.updateCanvasLayout();
            }
        });
        this._rootNode = new PNode();
        this._canvas.addWorldChild(this._rootNode);
        this._modeSwitch = new ModeSwitch();
        this._modeSwitch.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                HAModule.this.handleModeChange();
            }
        });
        this._atomicModelSelector = new AtomicModelSelector();
        this._atomicModelSelector.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                HAModule.this.handleAtomicModelChange();
            }
        });
        this._boxBeamGunParent = new PNode();
        this._boxOfHydrogenNode = new BoxOfHydrogenNode(HAConstants.BOX_OF_HYDROGEN_SIZE, HAConstants.TINY_BOX_SIZE);
        this._beamNode = new BeamNode(HAConstants.BEAM_SIZE, this._model.getGun());
        this._gunNode = new GunNode(this._model.getGun());
        this._boxBeamGunParent.addChild(this._beamNode);
        this._boxBeamGunParent.addChild(this._boxOfHydrogenNode);
        this._boxBeamGunParent.addChild(this._gunNode);
        double d5 = this._boxOfHydrogenNode.getFullBounds().getWidth();
        double d6 = this._gunNode.getFullBounds().getWidth();
        if (d5 > d6) {
            this._boxOfHydrogenNode.setOffset(0.0, 0.0);
            this._beamNode.setOffset((d5 - this._beamNode.getFullBounds().getWidth()) / 2.0, this._boxOfHydrogenNode.getFullBounds().getMaxY());
            this._gunNode.setOffset((d5 - d6) / 2.0 + 24.0, this._beamNode.getFullBounds().getMaxY());
        } else {
            this._boxOfHydrogenNode.setOffset((d6 - d5) / 2.0 - 24.0, 0.0);
            this._beamNode.setOffset(this._boxOfHydrogenNode.getFullBounds().getX() + (d5 - this._beamNode.getFullBounds().getWidth()) / 2.0, this._boxOfHydrogenNode.getFullBounds().getMaxY());
            this._gunNode.setOffset(-5.0, this._beamNode.getFullBounds().getMaxY());
        }
        this._animationBoxNode = new AnimationBoxNode(HAConstants.ANIMATION_BOX_SIZE);
        this._zoomIndicatorNode = new ZoomIndicatorNode();
        this._alphaParticleTracesNode = new TracesNode(this._model);
        this._alphaParticleTracesNode.setBounds(0.0, 0.0, this._animationBoxNode.getWidth(), this._animationBoxNode.getHeight());
        this._animationBoxNode.getTraceLayer().addChild(this._alphaParticleTracesNode);
        this._alphaParticleTracesNode.setEnabled(false);
        this._gunControlPanel = new GunControlPanel(this._model.getGun(), this._alphaParticleTracesNode);
        object = new DeBroglieViewControl();
        ((JComponent)object).setFont(phetFont);
        ((JComboBox)object).addActionListener(new ActionListener((DeBroglieViewControl)object){
            final /* synthetic */ DeBroglieViewControl val$deBroglieViewControl;
            {
                this.val$deBroglieViewControl = deBroglieViewControl;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                DeBroglieView deBroglieView = this.val$deBroglieViewControl.getSelectedView();
                HAModule.this.setDeBroglieView(deBroglieView);
            }
        });
        ((DeBroglieViewControl)object).setSelectedView(HADefaults.DEBROGLIE_VIEW);
        this._deBroglieViewControlWrapper = new PSwing((JComponent)object);
        ((PComboBox)object).setEnvironment(this._deBroglieViewControlWrapper, this._canvas);
        this._spectrometerCheckBox = new JCheckBox(HAResources.getString("label.showSpectrometer"));
        this._spectrometerCheckBox.setBackground(HAConstants.CANVAS_BACKGROUND);
        this._spectrometerCheckBox.setForeground(HAConstants.CANVAS_LABELS_COLOR);
        this._spectrometerCheckBox.setFont(phetFont);
        this._spectrometerCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                HAModule.this.handleSpectrometerCheckBox();
            }
        });
        this._spectrometerCheckBoxNode = new PSwing(this._spectrometerCheckBox);
        this._spectrometerCheckBoxNode.addInputEventListener(new CursorHandler());
        object = HAResources.getString("label.photonsEmitted");
        this._spectrometerNode = new SpectrometerNode(HAConstants.SPECTROMETER_SIZE, (String)object, this._spectrometerFont, 92.0, 7500.0);
        this._spectrometerNode.addCloseListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HAModule.this._spectrometerCheckBox.setSelected(false);
            }
        });
        this._spectrometerNode.addSnapshotListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HAModule.this.handleSpectrometerSnapshot();
            }
        });
        this._spectrometerSnapshotNodes = new ArrayList();
        this._energyDiagramCheckBox = new JCheckBox(HAResources.getString("label.showEnergyDiagram"));
        this._energyDiagramCheckBox.setBackground(HAConstants.CANVAS_BACKGROUND);
        this._energyDiagramCheckBox.setForeground(HAConstants.CANVAS_LABELS_COLOR);
        this._energyDiagramCheckBox.setFont(phetFont);
        this._energyDiagramCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                HAModule.this.updateEnergyDiagram();
                HAModule.this._legendNode.setVisible(!HAModule.this._energyDiagramCheckBox.isSelected());
            }
        });
        this._energyDiagramCheckBoxNode = new PSwing(this._energyDiagramCheckBox);
        this._energyDiagramCheckBoxNode.addInputEventListener(new CursorHandler());
        this._solarSystemEnergyDiagram = new SolarSystemEnergyDiagram(hAClock);
        this._bohrEnergyDiagram = new BohrEnergyDiagram(hAClock);
        this._deBroglieEnergyDiagram = new DeBroglieEnergyDiagram(hAClock);
        this._schrodingerEnergyDiagram = new SchrodingerEnergyDiagram(hAClock);
        object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HAModule.this._energyDiagramCheckBox.setSelected(false);
            }
        };
        this._solarSystemEnergyDiagram.addCloseListener((ActionListener)object);
        this._bohrEnergyDiagram.addCloseListener((ActionListener)object);
        this._deBroglieEnergyDiagram.addCloseListener((ActionListener)object);
        this._schrodingerEnergyDiagram.addCloseListener((ActionListener)object);
        this._energyDiagramParent = new PhetPNode();
        this._energyDiagramParent.addChild(this._solarSystemEnergyDiagram);
        this._energyDiagramParent.addChild(this._bohrEnergyDiagram);
        this._energyDiagramParent.addChild(this._deBroglieEnergyDiagram);
        this._energyDiagramParent.addChild(this._schrodingerEnergyDiagram);
        this._notToScaleLabel = new NotToScaleNode();
        this._legendNode = new LegendPanel.LegendNode();
        this._rootNode.addChild(this._modeSwitch);
        this._rootNode.addChild(this._atomicModelSelector);
        this._rootNode.addChild(this._boxBeamGunParent);
        this._rootNode.addChild(this._animationBoxNode);
        this._rootNode.addChild(this._zoomIndicatorNode);
        this._rootNode.addChild(this._gunControlPanel);
        this._rootNode.addChild(this._spectrometerCheckBoxNode);
        this._rootNode.addChild(this._spectrometerNode);
        this._rootNode.addChild(this._legendNode);
        this._rootNode.addChild(this._energyDiagramCheckBoxNode);
        this._rootNode.addChild(this._energyDiagramParent);
        this._rootNode.addChild(this._notToScaleLabel);
        this._rootNode.addChild(this._deBroglieViewControlWrapper);
        this._modelViewManager = new HAModelViewManager(this._model, this._animationBoxNode);
        this._clockControlPanel = new HAClockControlPanel((HAClock)this.getClock());
        this.setClockControlPanel(this._clockControlPanel);
        if (this.hasHelp()) {
            // empty if block
        }
        this.reset();
        this.updateCanvasLayout();
    }

    public Gun getGun() {
        return this._model.getGun();
    }

    public void reset() {
        this._modeSwitch.setExperimentSelected();
        this._atomicModelSelector.setSelection(HADefaults.ATOMIC_MODEL);
        Gun gun = this._model.getGun();
        gun.setEnabled(false);
        gun.setMode(HADefaults.GUN_MODE);
        gun.setLightType(HADefaults.LIGHT_TYPE);
        gun.setWavelength(94.0);
        gun.setLightIntensity(1.0);
        gun.setAlphaParticlesIntensity(1.0);
        this._alphaParticleTracesNode.setEnabled(false);
        this._spectrometerCheckBox.setSelected(false);
        this._spectrometerNode.setVisible(false);
        this._spectrometerNode.start();
        this._energyDiagramCheckBox.setSelected(false);
        this.updateEnergyDiagram();
    }

    public void updateCanvasLayout() {
        Dimension2D dimension2D = this._canvas.getWorldSize();
        if (dimension2D.getWidth() == 0.0 || dimension2D.getHeight() == 0.0) {
            return;
        }
        this._modeSwitch.setOffset(20.0, 10.0);
        PBounds pBounds = this._modeSwitch.getFullBounds();
        double d = pBounds.getX();
        double d2 = pBounds.getY() + pBounds.getHeight() + 10.0;
        this._atomicModelSelector.setOffset(d, d2);
        pBounds = this._atomicModelSelector.getFullBounds();
        this._boxBeamGunParent.setOffset(pBounds.getMaxX() + 20.0, pBounds.getY());
        pBounds = this._boxBeamGunParent.getFullBounds();
        PBounds pBounds2 = this._notToScaleLabel.getFullBounds();
        d = pBounds.getMaxX() + 20.0;
        d2 = 10.0 + pBounds2.getHeight() + 10.0;
        this._animationBoxNode.setOffset(d, d2);
        d = this._animationBoxNode.getFullBounds().getX();
        d2 = this._animationBoxNode.getFullBounds().getY();
        this._deBroglieViewControlWrapper.setOffset(d, d2);
        pBounds = this._animationBoxNode.getFullBounds();
        d = pBounds.getX() + (pBounds.getWidth() - this._notToScaleLabel.getFullBounds().getWidth()) / 2.0;
        d2 = (pBounds.getY() - this._notToScaleLabel.getFullBounds().getHeight()) / 2.0;
        this._notToScaleLabel.setOffset(d, d2);
        d = this._atomicModelSelector.getFullBounds().getMaxX() + 20.0;
        d2 = this._boxBeamGunParent.getFullBounds().getMaxY();
        this._gunControlPanel.setOffset(d, d2);
        double d3 = this._animationBoxNode.getFullBounds().getMaxY() + 10.0 - this._gunControlPanel.getFullBounds().getY();
        if (d3 > 0.0) {
            this._boxBeamGunParent.setOffset(this._boxBeamGunParent.getFullBounds().getX(), this._boxBeamGunParent.getFullBounds().getY() + d3);
            this._gunControlPanel.setOffset(this._gunControlPanel.getFullBounds().getX(), this._gunControlPanel.getFullBounds().getY() + d3);
        }
        PBounds pBounds3 = this._boxOfHydrogenNode.getTinyBoxGlobalBounds();
        Point2D point2D = this._rootNode.globalToLocal(pBounds3.getOrigin());
        Dimension2D dimension2D2 = this._rootNode.globalToLocal(pBounds3.getSize());
        PBounds pBounds4 = this._animationBoxNode.getFullBounds();
        this._zoomIndicatorNode.update(point2D, dimension2D2, pBounds4.getOrigin(), pBounds4.getSize());
        d = this._animationBoxNode.getFullBounds().getMaxX() + 20.0;
        d2 = 10.0;
        this._energyDiagramParent.setOffset(d, d2);
        this._energyDiagramCheckBoxNode.setOffset(d, d2);
        d = this._animationBoxNode.getFullBounds().getMaxX() + 20.0;
        d2 = this._animationBoxNode.getFullBounds().getY() + (this._animationBoxNode.getFullBounds().getHeight() - this._legendNode.getFullBounds().getHeight()) / 2.0;
        this._legendNode.setOffset(d, d2);
        d = this._gunControlPanel.getFullBounds().getMaxX() + 20.0;
        d2 = this._animationBoxNode.getFullBounds().getMaxY() + 10.0;
        this._spectrometerNode.setOffset(d, d2);
        this._spectrometerCheckBoxNode.setOffset(d, d2);
        this.initWiggleMe();
        this.applyLayoutHacks();
    }

    private void applyLayoutHacks() {
        this._gunControlPanel.updateWavelengthControlDragBounds();
    }

    private void initWiggleMe() {
        if (!this._wiggleMeInitialized) {
            String string = HAResources.getString("wiggleMe.gun");
            this._wiggleMe = new DefaultWiggleMe(this._canvas, string);
            this._wiggleMe.setArrowTailPosition(MotionHelpBalloon.BOTTOM_CENTER);
            this._rootNode.addChild(this._wiggleMe);
            PNode pNode = this._gunNode.getButtonNode();
            Rectangle2D rectangle2D = this._rootNode.globalToLocal(pNode.getGlobalFullBounds());
            double d = rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
            double d2 = rectangle2D.getY();
            this._wiggleMe.setOffset(0.0, -100.0);
            this._wiggleMe.animateTo(d, d2);
            this._canvas.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    HAModule.this._wiggleMe.setEnabled(false);
                    HAModule.this._rootNode.removeChild(HAModule.this._wiggleMe);
                    HAModule.this._canvas.removeInputEventListener(this);
                    HAModule.this._wiggleMe = null;
                }
            });
            this._wiggleMeInitialized = true;
        }
    }

    private void handleModeChange() {
        this._atomicModelSelector.setVisible(this._modeSwitch.isPredictionSelected());
        this.updateAtomicModel();
        this.updateEnergyDiagram();
        this._model.removeAllAlphaParticles();
        this._model.removeAllPhotons();
        this._spectrometerNode.reset();
        this._legendNode.setVisible(this._modeSwitch.isPredictionSelected());
    }

    private void handleAtomicModelChange() {
        this.updateAtomicModel();
        this.updateEnergyDiagram();
        this._model.removeAllAlphaParticles();
        this._model.removeAllPhotons();
        this._spectrometerNode.reset();
    }

    public void updateAtomicModel() {
        Object object;
        Object object2;
        Object object3;
        this._deBroglieViewControlWrapper.setVisible(false);
        this._alphaParticleTracesNode.clear();
        this._solarSystemEnergyDiagram.clearAtom();
        this._bohrEnergyDiagram.clearAtom();
        this._deBroglieEnergyDiagram.clearAtom();
        this._schrodingerEnergyDiagram.clearAtom();
        Point2D point2D = this._model.getSpace().getCenter();
        if (this._modeSwitch.isExperimentSelected()) {
            object3 = new ExperimentModel(point2D, this.getClock(), this._model.getGun());
            object2 = object3;
        } else {
            object3 = this._atomicModelSelector.getSelection();
            if (object3 == AtomicModel.BILLIARD_BALL) {
                object2 = new BilliardBallModel(point2D);
            } else if (object3 == AtomicModel.PLUM_PUDDING) {
                object2 = new PlumPuddingModel(point2D);
            } else if (object3 == AtomicModel.SOLAR_SYSTEM) {
                object2 = object = new SolarSystemModel(point2D);
                this._solarSystemEnergyDiagram.setAtom((SolarSystemModel)object);
            } else if (object3 == AtomicModel.BOHR) {
                object2 = object = new BohrModel(point2D);
                this._bohrEnergyDiagram.setAtom((BohrModel)object);
            } else if (object3 == AtomicModel.DEBROGLIE) {
                object2 = object = new DeBroglieModel(point2D);
                this._deBroglieEnergyDiagram.setAtom((BohrModel)object);
                this._deBroglieViewControlWrapper.setVisible(true);
            } else if (object3 == AtomicModel.SCHRODINGER) {
                object2 = object = new SchrodingerModel(point2D, this.getClock(), this._model.getGun());
                this._schrodingerEnergyDiagram.setAtom((SchrodingerModel)object);
            } else {
                throw new UnsupportedOperationException("unsupported atom model: " + (Object)object3);
            }
        }
        assert (object2 != null);
        ((AbstractHydrogenAtom)object2).addAtomListener(this._spectrometerNode);
        this._model.setAtom((AbstractHydrogenAtom)object2);
        int n = AbstractHydrogenAtom.getGroundState();
        object = ((AbstractHydrogenAtom)object2).getTransitionWavelengths(n);
        this._gunControlPanel.setTransitionWavelengths((double[])object);
    }

    public void setDeBroglieView(DeBroglieView deBroglieView) {
        DeBroglieModel.DEFAULT_VIEW = deBroglieView;
        AbstractHydrogenAtom abstractHydrogenAtom = this._model.getAtom();
        if (abstractHydrogenAtom instanceof DeBroglieModel) {
            ((DeBroglieModel)abstractHydrogenAtom).setView(deBroglieView);
        }
    }

    public void handleSpectrometerCheckBox() {
        boolean bl = this._spectrometerCheckBox.isSelected();
        this._spectrometerNode.setVisible(bl);
        for (SpectrometerNode.SpectrometerSnapshotNode spectrometerSnapshotNode : this._spectrometerSnapshotNodes) {
            spectrometerSnapshotNode.setVisible(bl);
        }
    }

    private void handleSpectrometerSnapshot() {
        ++this._spectrometerSnapshotsCounter;
        String string = HAResources.getString("label.snapshot") + " " + this._spectrometerSnapshotsCounter + ": ";
        string = this._modeSwitch.isPredictionSelected() ? string + this._atomicModelSelector.getSelectionName() : string + HAResources.getString("title.spectrometer.experiment");
        final SpectrometerNode.SpectrometerSnapshotNode spectrometerSnapshotNode = this._spectrometerNode.getSnapshot(string);
        spectrometerSnapshotNode.addCloseListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HAModule.this._rootNode.removeChild(spectrometerSnapshotNode);
                HAModule.this._spectrometerSnapshotNodes.remove(spectrometerSnapshotNode);
            }
        });
        this._rootNode.addChild(spectrometerSnapshotNode);
        PBounds pBounds = this._spectrometerNode.getFullBounds();
        double d = 0.0;
        double d2 = 0.0;
        if (this._spectrometerSnapshotNodes.size() == 0) {
            d = pBounds.getX();
            d2 = pBounds.getY() - spectrometerSnapshotNode.getFullBounds().getHeight() - 5.0;
        } else {
            PBounds pBounds2 = ((PNode)this._spectrometerSnapshotNodes.get(this._spectrometerSnapshotNodes.size() - 1)).getFullBounds();
            d = pBounds2.getX() - 30.0;
            d2 = pBounds2.getY() - 20.0;
        }
        spectrometerSnapshotNode.setOffset(d, d2);
        this._spectrometerSnapshotNodes.add(spectrometerSnapshotNode);
    }

    public void updateEnergyDiagram() {
        AtomicModel atomicModel = this._atomicModelSelector.getSelection();
        this._energyDiagramCheckBoxNode.setVisible(false);
        this._bohrEnergyDiagram.setVisible(false);
        this._deBroglieEnergyDiagram.setVisible(false);
        this._schrodingerEnergyDiagram.setVisible(false);
        this._solarSystemEnergyDiagram.setVisible(false);
        if (this._modeSwitch.isPredictionSelected()) {
            if (atomicModel == AtomicModel.BOHR) {
                this._energyDiagramCheckBoxNode.setVisible(true);
                this._bohrEnergyDiagram.setVisible(this._energyDiagramCheckBox.isSelected());
            } else if (atomicModel == AtomicModel.DEBROGLIE) {
                this._energyDiagramCheckBoxNode.setVisible(true);
                this._deBroglieEnergyDiagram.setVisible(this._energyDiagramCheckBox.isSelected());
            } else if (atomicModel == AtomicModel.SCHRODINGER) {
                this._energyDiagramCheckBoxNode.setVisible(true);
                this._schrodingerEnergyDiagram.setVisible(this._energyDiagramCheckBox.isSelected());
            } else if (atomicModel == AtomicModel.SOLAR_SYSTEM) {
                this._energyDiagramCheckBoxNode.setVisible(true);
                this._solarSystemEnergyDiagram.setVisible(this._energyDiagramCheckBox.isSelected());
            }
        }
    }
}

