/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.hydrogenatom.model.AlphaParticle;
import edu.colorado.phet.hydrogenatom.model.FixedObject;
import edu.colorado.phet.hydrogenatom.model.Photon;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public abstract class AbstractHydrogenAtom
extends FixedObject
implements ModelElement {
    public static double COLLISION_CLOSENESS = 19.5;
    private ArrayList<AtomListener> _listeners = new ArrayList();

    public AbstractHydrogenAtom(Point2D point2D, double d) {
        super(point2D, d);
    }

    public void cleanup() {
        this.removeAllAtomListeners();
    }

    public static int getGroundState() {
        return 1;
    }

    public double[] getTransitionWavelengths(int n) {
        return null;
    }

    public void movePhoton(Photon photon, double d) {
        double d2 = photon.getSpeed();
        double d3 = d2 * d;
        double d4 = photon.getOrientation();
        double d5 = Math.cos(d4) * d3;
        double d6 = Math.sin(d4) * d3;
        double d7 = photon.getX() + d5;
        double d8 = photon.getY() + d6;
        photon.setPosition(d7, d8);
    }

    public void moveAlphaParticle(AlphaParticle alphaParticle, double d) {
        double d2 = alphaParticle.getSpeed();
        double d3 = d2 * d;
        double d4 = alphaParticle.getOrientation();
        double d5 = Math.cos(d4) * d3;
        double d6 = Math.sin(d4) * d3;
        double d7 = alphaParticle.getX() + d5;
        double d8 = alphaParticle.getY() + d6;
        alphaParticle.setPosition(d7, d8);
    }

    protected static boolean pointsCollide(Point2D point2D, Point2D point2D2, double d) {
        return point2D.distance(point2D2) <= d;
    }

    public void stepInTime(double d) {
    }

    public void addAtomListener(AtomListener atomListener) {
        this._listeners.add(atomListener);
    }

    public void removeAllAtomListeners() {
        this._listeners.clear();
    }

    protected void firePhotonAbsorbed(Photon photon) {
        for (AtomListener atomListener : new ArrayList<AtomListener>(this._listeners)) {
            atomListener.photonAbsorbed(photon);
        }
    }

    protected void firePhotonEmitted(Photon photon) {
        for (AtomListener atomListener : new ArrayList<AtomListener>(this._listeners)) {
            atomListener.photonEmitted(photon);
        }
    }

    public static interface AtomListener {
        public void photonAbsorbed(Photon var1);

        public void photonEmitted(Photon var1);
    }
}

