/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.dialog;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.hydrogenatom.HAResources;
import edu.colorado.phet.hydrogenatom.model.BohrModel;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class TransitionsDialog
extends PaintImmediateDialog {
    private static final DecimalFormat WAVELENGTH_FORMATTER = new DecimalFormat("0");

    public TransitionsDialog(Frame frame) {
        super(frame, HAResources.getString("dialog.transitions.title"));
        this.setResizable(false);
        JPanel jPanel = this.createInputPanel();
        JPanel jPanel2 = this.createActionsPanel();
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.setFillHorizontal();
        verticalLayoutPanel.add(jPanel);
        verticalLayoutPanel.add(new JSeparator());
        verticalLayoutPanel.add(jPanel2);
        this.setContentPane(verticalLayoutPanel);
        this.pack();
        SwingUtils.centerDialogInParent(this);
    }

    private JPanel createInputPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 20, 10, 20));
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        easyGridBagLayout.setInsets(new Insets(0, 0, 0, 0));
        easyGridBagLayout.setMinimumWidth(1, 15);
        easyGridBagLayout.setMinimumWidth(3, 3);
        jPanel.setLayout(easyGridBagLayout);
        int n = 0;
        easyGridBagLayout.addAnchoredComponent(new JLabel(HAResources.getString("dialog.transitions.transition")), n, 0, 10);
        easyGridBagLayout.addAnchoredComponent(new JLabel(HAResources.getString("dialog.transitions.wavelength")), n, 2, 13);
        easyGridBagLayout.addAnchoredComponent(new JLabel("(nm)"), n, 4, 17);
        easyGridBagLayout.addComponent(new JSeparator(), ++n, 0, 5, 1, 17, 2);
        ++n;
        int n2 = BohrModel.getGroundState();
        int n3 = BohrModel.getNumberOfStates();
        int n4 = n2 + n3 - 1;
        for (int i = n2; i < n4; ++i) {
            for (int j = i + 1; j <= n4; ++j) {
                Object[] objectArray = new Object[]{new Integer(i), new Integer(j)};
                String string = MessageFormat.format("{0} <-> {1}", objectArray);
                String string2 = WAVELENGTH_FORMATTER.format(BohrModel.getWavelengthAbsorbed(i, j));
                easyGridBagLayout.addAnchoredComponent(new JLabel(string), n, 0, 10);
                easyGridBagLayout.addAnchoredComponent(new JLabel(string2), n, 2, 13);
                ++n;
            }
        }
        return jPanel;
    }

    private JPanel createActionsPanel() {
        JButton jButton = new JButton(HAResources.getString("button.close"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransitionsDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 1, 0, 0));
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(jPanel);
        return jPanel2;
    }
}

