/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.control;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.hydrogenatom.HAResources;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class ModeSwitch
extends PhetPNode {
    private static final Color ON_COLOR = Color.WHITE;
    private static final Color OFF_COLOR = Color.BLACK;
    private static final Stroke LINE_STROKE = new BasicStroke(2.0f);
    private PhetPNode _switchUpNode;
    private PhetPNode _switchDownNode;
    private PPath _topLineNode;
    private PPath _bottomLineNode;
    private PText _topTitleNode;
    private PText _topSubtitleNode;
    private PText _bottomTitleNode;
    private PText _bottomSubtitleNode;
    private EventListenerList _listenerList;
    private boolean _isExperimentMode;

    public ModeSwitch() {
        int n = HAResources.getInt("modeSwitch.big.font.size", 16);
        PhetFont phetFont = new PhetFont(1, n);
        int n2 = HAResources.getInt("modeSwitch.small.font.size", 16);
        PhetFont phetFont2 = new PhetFont(0, n2);
        PImage pImage = HAResources.getImageNode("modePanel.png");
        this._switchUpNode = new PhetPNode(HAResources.getImageNode("modeSwitchUp.png"));
        this._switchDownNode = new PhetPNode(HAResources.getImageNode("modeSwitchDown.png"));
        this._topTitleNode = new PText(HAResources.getString("label.experiment"));
        this._topSubtitleNode = new PText(HAResources.getString("label.whatReallyHappens"));
        this._bottomTitleNode = new PText(HAResources.getString("label.prediction"));
        this._bottomSubtitleNode = new PText(HAResources.getString("label.whatTheModelPredicts"));
        this._topTitleNode.setFont(phetFont);
        this._topSubtitleNode.setFont(phetFont2);
        this._bottomTitleNode.setFont(phetFont);
        this._bottomSubtitleNode.setFont(phetFont2);
        this._topLineNode = new PPath();
        this._topLineNode.setPathTo(new Line2D.Double(0.0, 0.0, 10.0, 0.0));
        this._topLineNode.setStroke(LINE_STROKE);
        this._topLineNode.setStrokePaint(ON_COLOR);
        this._bottomLineNode = new PPath();
        this._bottomLineNode.setPathTo(new Line2D.Double(0.0, 0.0, 10.0, 0.0));
        this._bottomLineNode.setStroke(LINE_STROKE);
        this._bottomLineNode.setStrokePaint(ON_COLOR);
        this.addChild(pImage);
        this.addChild(this._topLineNode);
        this.addChild(this._bottomLineNode);
        this.addChild(this._topTitleNode);
        this.addChild(this._topSubtitleNode);
        this.addChild(this._bottomTitleNode);
        this.addChild(this._bottomSubtitleNode);
        this.addChild(this._switchUpNode);
        this.addChild(this._switchDownNode);
        Object object = pImage.getFullBounds();
        Object object2 = this._switchDownNode.getFullBounds();
        pImage.setOffset(0.0, 0.0);
        this._switchDownNode.setOffset(((Rectangle2D.Double)object).getX() + 10.0, ((Rectangle2D.Double)object).getY() + ((Rectangle2D.Double)object).getHeight() / 3.0 - ((Rectangle2D.Double)object2).getHeight() / 2.0);
        this._switchUpNode.setOffset(this._switchDownNode.getOffset());
        object2 = this._switchDownNode.getFullBounds();
        PBounds pBounds = this._topLineNode.getFullBounds();
        this._topLineNode.setOffset(((Rectangle2D.Double)object2).getX() + ((Rectangle2D.Double)object2).getWidth() - 5.0, ((Rectangle2D.Double)object2).getY() - pBounds.getHeight() + 10.0);
        this._bottomLineNode.setOffset(((Rectangle2D.Double)object2).getX() + ((Rectangle2D.Double)object2).getWidth() - 5.0, ((Rectangle2D.Double)object2).getY() + ((Rectangle2D.Double)object2).getHeight() - 10.0);
        pBounds = this._topLineNode.getFullBounds();
        PBounds pBounds2 = this._topTitleNode.getFullBounds();
        this._topTitleNode.setOffset(pBounds.getX() + pBounds.getWidth() + 5.0, pBounds.getY() - pBounds2.getHeight() / 2.0);
        pBounds2 = this._topTitleNode.getFullBounds();
        this._topSubtitleNode.setOffset(pBounds2.getX(), pBounds2.getY() + pBounds2.getHeight());
        PBounds pBounds3 = this._bottomLineNode.getFullBounds();
        PBounds pBounds4 = this._bottomTitleNode.getFullBounds();
        this._bottomTitleNode.setOffset(pBounds3.getX() + pBounds3.getWidth() + 5.0, pBounds3.getY() - pBounds4.getHeight() / 2.0);
        pBounds4 = this._bottomTitleNode.getFullBounds();
        this._bottomSubtitleNode.setOffset(pBounds4.getX(), pBounds4.getY() + pBounds4.getHeight());
        this.removeChild(pImage);
        object = this.getFullBounds();
        object2 = pImage.getFullBounds();
        double d = (((Rectangle2D.Double)object).getWidth() + 20.0) / ((Rectangle2D.Double)object2).getWidth();
        double d2 = (((Rectangle2D.Double)object).getHeight() + 20.0) / ((Rectangle2D.Double)object2).getHeight();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d, d2);
        pImage.setTransform(affineTransform);
        this.addChild(pImage);
        pImage.moveToBack();
        this._listenerList = new EventListenerList();
        pImage.setPickable(false);
        this._topLineNode.setPickable(false);
        this._bottomLineNode.setPickable(false);
        object = new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                ModeSwitch.this.setExperimentSelected(true);
            }
        };
        object2 = new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                ModeSwitch.this.setExperimentSelected(false);
            }
        };
        this._switchUpNode.addInputEventListener(new CursorHandler());
        this._switchUpNode.addInputEventListener((PInputEventListener)object2);
        this._topTitleNode.addInputEventListener((PInputEventListener)object);
        this._topSubtitleNode.addInputEventListener((PInputEventListener)object);
        this._switchDownNode.addInputEventListener(new CursorHandler());
        this._switchDownNode.addInputEventListener((PInputEventListener)object);
        this._bottomTitleNode.addInputEventListener((PInputEventListener)object2);
        this._bottomSubtitleNode.addInputEventListener((PInputEventListener)object2);
        this.setExperimentSelected();
    }

    public void setExperimentSelected() {
        this.setExperimentSelected(true);
    }

    public boolean isExperimentSelected() {
        return this._isExperimentMode;
    }

    public boolean isPredictionSelected() {
        return !this._isExperimentMode;
    }

    private void setExperimentSelected(boolean bl) {
        this._isExperimentMode = bl;
        this.updateUI();
        this.fireChangeEvent(new ChangeEvent(this));
    }

    private void updateUI() {
        boolean bl = this._isExperimentMode;
        this._switchUpNode.setVisible(bl);
        this._switchDownNode.setVisible(!bl);
        Color color = bl ? ON_COLOR : OFF_COLOR;
        this._topLineNode.setStrokePaint(color);
        this._topTitleNode.setTextPaint(color);
        this._topSubtitleNode.setTextPaint(color);
        Color color2 = !bl ? ON_COLOR : OFF_COLOR;
        this._bottomLineNode.setStrokePaint(color2);
        this._bottomTitleNode.setTextPaint(color2);
        this._bottomSubtitleNode.setTextPaint(color2);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }
}

