/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.control;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.hydrogenatom.HAResources;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class LightTypeControl
extends JPanel {
    private JRadioButton _whiteButton;
    private JRadioButton _monochromaticButton;
    private EventListenerList _listenerList = new EventListenerList();

    public LightTypeControl(Font font) {
        this._whiteButton = new JRadioButton(HAResources.getString("button.white"));
        this._whiteButton.setFont(font);
        this._monochromaticButton = new JRadioButton(HAResources.getString("button.monochromatic"));
        this._monochromaticButton.setFont(font);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._whiteButton);
        buttonGroup.add(this._monochromaticButton);
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        easyGridBagLayout.setInsets(new Insets(0, 5, 0, 5));
        this.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(this._whiteButton, n, n2++);
        easyGridBagLayout.addComponent(this._monochromaticButton, n, n2);
        this.setOpaque(false);
        this._whiteButton.setOpaque(false);
        this._monochromaticButton.setOpaque(false);
        final LightTypeControl lightTypeControl = this;
        this._whiteButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (LightTypeControl.this._whiteButton.isSelected()) {
                    LightTypeControl.this.fireChangeEvent(new ChangeEvent(lightTypeControl));
                }
            }
        });
        this._monochromaticButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (LightTypeControl.this._monochromaticButton.isSelected()) {
                    LightTypeControl.this.fireChangeEvent(new ChangeEvent(lightTypeControl));
                }
            }
        });
        this.setWhiteSelected(true);
    }

    public void setWhiteSelected(boolean bl) {
        this._whiteButton.setSelected(bl);
        this._monochromaticButton.setSelected(!bl);
    }

    public void setMonochromaticSelected(boolean bl) {
        this._monochromaticButton.setSelected(bl);
        this._whiteButton.setSelected(!bl);
    }

    public boolean isMonochromaticSelected() {
        return this._monochromaticButton.isSelected();
    }

    public void setLabelsForeground(Color color) {
        this._whiteButton.setForeground(color);
        this._monochromaticButton.setForeground(color);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }
}

