/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.view;

import edu.colorado.phet.greenhouse.common.graphics.Graphic;
import edu.colorado.phet.greenhouse.model.Disk;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;

public class DiskGraphic
implements Graphic {
    private Disk disk;
    private Paint paint;
    private Ellipse2D.Double circle = new Ellipse2D.Double();

    public DiskGraphic(Disk disk, Paint paint) {
        this.disk = disk;
        this.paint = paint;
        this.update();
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public void paint(Graphics2D graphics2D) {
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setPaint(this.paint);
        graphics2D.fill(this.circle);
        graphics2D.setRenderingHints(renderingHints);
    }

    public void update() {
        this.circle.setFrameFromCenter(this.disk.getCM().getX(), this.disk.getCM().getY(), this.disk.getCM().getX() + this.disk.getRadius(), this.disk.getCM().getY() - this.disk.getRadius());
    }
}

